/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Pair;

class FilteredVariableProperties
extends UnaryRead<Variable, Collection<Pair<String, Variable>>> {
    static final String CLASSIFICATION = "http://www.simantics.org/Spreadsheet-1.2/Attribute";

    public FilteredVariableProperties(Variable variable) {
        super((Object)variable);
    }

    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<Pair<String, Variable>> result = new ArrayList<Pair<String, Variable>>();
        for (Variable var : ((Variable)this.parameter).getProperties(graph, CLASSIFICATION)) {
            Variable editable;
            String name = var.getName(graph);
            result.add((Pair<String, Variable>)Pair.make((Object)name, (Object)var));
            Variable expression = var.getPossibleProperty(graph, "expression");
            if (expression != null) {
                result.add((Pair<String, Variable>)Pair.make((Object)(String.valueOf(name) + "#expression"), (Object)expression));
            }
            if ((editable = var.getPossibleProperty(graph, "editable")) == null) continue;
            result.add((Pair<String, Variable>)Pair.make((Object)(String.valueOf(name) + "#editable"), (Object)editable));
        }
        return result;
    }
}

