/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellValue
extends VariableRead<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValue.class);

    public CellValue(Variable variable) {
        super(variable);
    }

    public Object perform(ReadGraph graph) throws DatabaseException {
        Object value = this.variable.getValue(graph);
        String propertyName = this.variable.getName(graph);
        if ("content".equals(propertyName)) {
            if (value == null) {
                return Variant.ofInstance((Object)("Null content: " + this.variable.getURI(graph)));
            }
            if (value instanceof Variable) {
                Variable var = (Variable)value;
                Object value2 = var.getValue(graph);
                if (value2 instanceof Variant) {
                    return value;
                }
                if (value2 == null) {
                    return Variant.ofInstance((Object)("Null value from " + var.getURI(graph)));
                }
                try {
                    Binding binding = Bindings.getBinding(value2.getClass());
                    return new Variant(binding, value2);
                }
                catch (BindingConstructionException e) {
                    String msg = "Unsupported content " + value2 + " from " + var.getURI(graph);
                    LOGGER.error(msg, (Throwable)e);
                    return Variant.ofInstance((Object)msg);
                }
            }
            if (!(value instanceof Variant)) {
                try {
                    Binding binding = Bindings.getBinding(value.getClass());
                    return new Variant(binding, value);
                }
                catch (BindingConstructionException e) {
                    String msg = "Unsupported content " + value + " at " + this.variable.getURI(graph);
                    LOGGER.error(msg, (Throwable)e);
                    return Variant.ofInstance((Object)msg);
                }
            }
        }
        return value;
    }
}

