/*******************************************************************************
 * Copyright (c) 2013, 2014 Association for Decentralized 
 * Information Management in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the THTH Simantics 
 * Division Member Component License which accompanies this 
 * distribution, and is available at
 * http://www.simantics.org/legal/sdmcl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.common;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITreeTableCell;
import org.simantics.document.server.io.SimpleFont;

public class TreeTableCell extends TableCell implements ITreeTableCell {	
	
	private int parent = -1;
	private Object parentData;
	
	private boolean editable = true;
	private Object data;

	public TreeTableCell() {
	}
	
	public TreeTableCell(String text, Object data, Object font, Object parentData, int parent, int row, int column, boolean editable) {
		super(column, row, 0, 0, text, (IFont)font, null, null, false, 1, 1);
		this.editable = editable;
		this.parent = parent;
		this.parentData = parentData;
		this.data = data;
	}
	
	@Override
	public int getRowSpan() {
		throw new IllegalStateException("Row span is not supported in TreeTableCell");
	}
	
	@Override
	public int getColumnSpan() {
		throw new IllegalStateException("Column span is not supported in TreeTableCell");
	}
	
	public static TreeTableCell createTreeTableCell(String text, Object data, Object font, int parent, int row, int column, boolean editable) {
		return new TreeTableCell(text, data, extractIFont(font), null, parent, row, column, editable);
	}
	
	public static TreeTableCell createTreeTableCell2(String text, Object data, Object font, Object parentData, int row, int column, boolean editable) {
		return new TreeTableCell(text, data, extractIFont(font), parentData, -1, row, column, editable);
	}

	private static IFont extractIFont(Object font) {
		if(font instanceof FontDescriptor) {
			FontDescriptor descriptor = (FontDescriptor)font;
			String family = "";
			String style = "";
			int size = 12;
			for(FontData d : descriptor.getFontData()) {
				family = d.getName();
				if((d.getStyle() & SWT.ITALIC) != 0) style += "Italic";
				if((d.getStyle() & SWT.BOLD) != 0) style += "Bold";
				size = d.getHeight();
			}
			return new SimpleFont(family, style, size);
		}
		return null;
	}
	
	public void setParent(int parent) {
		this.parent = parent;
	}
	
	@Override
	public Object getParentData() {
		return parentData;
	}
	
	@Override
	public int getParent() {
		return parent;
	}

	@Override
	public Object getData() {
		return data;
	}

	@Override
	public boolean isEditable() {
		return editable;
	}

	@Override
	public int hashCode() {
		
		final int prime = 31;
		
		int result = super.hashCode();

		result = data != null ? prime * result + data.hashCode() : parent;
		result = parentData != null ? prime * result + parentData.hashCode() : result;
		result = prime * result + Integer.hashCode(parent);
		result = prime * result + Boolean.hashCode(editable);
		
		return result;
		
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TreeTableCell other = (TreeTableCell) obj;
		if (data == null) {
			if (other.data != null)
				return false;
		} else if (!data.equals(other.data))
			return false;
		if (parentData == null) {
			if (other.parentData != null)
				return false;
		} else if (!parentData.equals(other.parentData))
			return false;
		if (parent != other.parent)
			return false;
		if (editable != other.editable)
			return false;
		return super.equals(obj);
	}
	
}
