/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.internal;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;
import org.simantics.ModelBrowserPreferences;

/**
 * @author Tuukka Lehtonen <tuukka.lehtonen@semantum.fi>
 */
public class ModelBrowserPreferenceInitializer extends AbstractPreferenceInitializer {

    public void initializeDefaultPreferences() {
        IScopeContext context = DefaultScope.INSTANCE;
        Preferences node = context.getNode(ModelBrowserPreferences.P_NODE);
        node.put(ModelBrowserPreferences.P_ONTOLOGY_VISIBILITY, ModelBrowserPreferences.DEFAULT_ONTOLOGY_VISIBILITY);
    }

}
