/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics;

import java.io.IOException;

import org.simantics.databoard.util.binary.InputStreamReadable;

/**
 * @author Tuukka Lehtonen
 */
public class ConsoleUserAgent implements PlatformUserAgent {

    @Override
    public int showPrompt(String title, String message, String[] options, int defaultChoice) {
        try {
            boolean ok = false;
            while (!ok) {
                System.out.println("== " + title + " ==\n");
                System.out.println(message + "\n");
                for (int i = 0; i < options.length; ++i)
                    System.out.println("[" + i + "] " + options[i]);
                System.out.print("Select [");
                for (int i = 0; i < options.length; ++i)
                    System.out.print(i);
                System.out.println("] (default = " + defaultChoice + ") ? ");

                InputStreamReadable rdr  = new InputStreamReadable(System.in, 1);
                String str = rdr.readLine();
                //System.out.println("READ: '" + str + "'");
                try {
                    int choice = Integer.parseInt(str);
                    if (choice >= 0 && choice < options.length) {
                        ok = true;
                        return choice;
                    }
                } catch (NumberFormatException e) {
                    // Just repeat the question if input is unintelligible
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return defaultChoice;
    }

}
