/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.toolkit;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.simulator.IDynamicExperimentLocal;
import org.simantics.simulator.toolkit.DynamicExperimentActionContext;
import org.simantics.simulator.toolkit.DynamicExperimentThread;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;

public class DynamicExperimentThreadSequenceRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicExperimentActionContext runAction(final IDynamicExperimentLocal experiment, final DynamicExperimentThread thread, Function action, final boolean simulateAndWaitCompletion) {
        final DynamicExperimentActionContext context = new DynamicExperimentActionContext(experiment);
        context.scheduleNextStep((Function1)action);
        final Object sync = new Object();
        final SCLContext sclContext = SCLContext.getCurrent();
        thread.addListener(new DynamicExperimentThreadListener(){

            @Override
            public void beforeStep() {
                if (!context.isStopped()) {
                    SCLContext.push((SCLContext)sclContext);
                    context.handleStep(experiment.getSimulationTime());
                    SCLContext.pop();
                }
                this.removeIfStopped();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeIfStopped() {
                if (context.isStopped()) {
                    thread.removeListener(this);
                    if (simulateAndWaitCompletion) {
                        experiment.simulate(false);
                        Object object = sync;
                        synchronized (object) {
                            sync.notify();
                        }
                    }
                    experiment.shutdown((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
        if (simulateAndWaitCompletion) {
            experiment.simulate(true);
            try {
                Object object = sync;
                synchronized (object) {
                    while (!context.isStopped()) {
                        sync.wait(1000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                context.stop();
            }
            if (context.exceptions != null && !context.exceptions.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Action failures:");
                for (Exception e : context.exceptions) {
                    builder.append("\n");
                    builder.append(e.getMessage());
                }
                throw new RuntimeException(builder.toString());
            }
        }
        return context;
    }
}

