package org.simantics.simulator.toolkit.db;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.procedure.Listener;

/**
 * @author Antti Villberg
 * @since 1.34.0
 */
public class ExperimentStateExternalRead extends ParametrizedPrimitiveRead<Object, Integer> {

	private int value = 0;
	private Listener<Integer> listener = null;

	public ExperimentStateExternalRead(Object experiment) {
		super(experiment);
	}

	@Override
	public void register(ReadGraph graph, Listener<Integer> procedure) {
		procedure.execute(value);
		if (procedure.isDisposed())
			return;
		if (listener != null)
			throw new RuntimeDatabaseException("Internal error");
		listener = procedure;
	}

	@Override
	public void unregistered() {
		listener = null;
	}

	public void fire() {
		value++;
		if (listener != null)
			listener.execute(value);
	}

}