/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.export;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.simulation.ontology.SimulationResource;

public class DiscoverExperimentResults
implements DiscoverAction {
    public Read<Collection<String>> discoverRequest(final Collection<String> startLocations) throws ExportException {
        return new Read<Collection<String>>(){

            public Collection<String> perform(ReadGraph graph) throws DatabaseException {
                SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                Instances instances = (Instances)graph.adapt(SIM.Experiment, Instances.class);
                ArrayList<String> result = new ArrayList<String>();
                for (String startingLocation : startLocations) {
                    Resource sl = graph.getResource(startingLocation);
                    for (Resource diagram : instances.find(graph, sl)) {
                        result.add(graph.getURI(diagram));
                    }
                }
                return result;
            }
        };
    }

    public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {
        try {
            return (Collection)ctx.session.syncRequest(this.discoverRequest(startLocations));
        }
        catch (DatabaseException e) {
            if (e.getCause() instanceof ExportException) {
                throw (ExportException)e.getCause();
            }
            throw new ExportException((Throwable)e);
        }
    }
}

