/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import java.text.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.simulation.experiment.SimulationTimeUtil;
import org.simantics.simulation.ui.handlers.e4.TimeValidator;

public class TimeInputDialog
extends InputDialog {
    private Text statusText;

    public TimeInputDialog(Shell parentShell, String dialogTitle, String topic, String initialValue) {
        super(parentShell, dialogTitle, TimeInputDialog.message(topic), initialValue, (IInputValidator)new TimeValidator());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.statusText = new Text(composite, 72);
        this.statusText.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected void validateInput() {
        super.validateInput();
        try {
            double t = (Double)SimulationTimeUtil.getTimeFormat().parseObject(this.getText().getText());
            this.statusText.setText(TimeInputDialog.statusMessage(t));
        }
        catch (ParseException parseException) {
            this.statusText.setText("");
        }
    }

    private static String message(String topic) {
        return NLS.bind((String)"Give {0} in seconds or timestamp format ([Yy] [Dd] HH:mm:ss.ddd)", (Object)topic);
    }

    private static String statusMessage(double time) {
        return NLS.bind((String)"Specified time is {0} s ({1})", (Object)SimulationTimeUtil.formatSeconds((double)time), (Object)SimulationTimeUtil.formatHMSS((double)time));
    }
}

