package org.simantics.simulation.project;

import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public final class ExperimentManagerKeys {

    /**
     * Affects how {@link ExperimentManager} works when new experiments are
     * activated through
     * {@link IExperimentManager#startExperiment(org.simantics.db.Resource, IExperimentActivationListener, boolean)}
     * . If this hint is set to {@link ExperimentManagerMode#SINGLE_EXPERIMENT},
     * the manager will shut down the previously active experiment before
     * activating the new experiment. Otherwise the previous experiment will not
     * be touched by ExperimentManager.
     */
    public static final Key EXPERIMENT_MANAGER_MODE = new KeyOf(ExperimentManagerMode.class, "EXPERIMENT_MANAGER_MODE");

}
