/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.ModelledViewTabContributor;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;

public class VariableTabContribution
implements TabContribution<Variable> {
    private final Resource configuration;

    public VariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
    }

    @Override
    public boolean accept(ReadGraph graph, Object input) {
        return input instanceof Variable;
    }

    @Override
    public void contribute(ReadGraph graph, Variable variable, Collection<ComparableTabContributor> result) throws DatabaseException {
        Boolean pass;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Resource view = graph.getPossibleObject(this.configuration, SEL.VariableTabContribution_HasView);
        if (view == null) {
            throw new DatabaseException("No view for " + graph.getPossibleURI(this.configuration));
        }
        Integer priority = (Integer)graph.getPossibleRelatedValue(this.configuration, SEL.VariableTabContribution_HasPriority, (Binding)Bindings.INTEGER);
        String label = (String)graph.getPossibleRelatedValue(this.configuration, L0.HasLabel);
        for (Resource r : graph.getObjects(this.configuration, SEL.VariableTabContribution_HasTest)) {
            pass = (Boolean)Functions.exec((RequestProcessor)graph, (Resource)r, (Object[])new Object[]{graph, variable});
            if (Boolean.TRUE.equals(pass)) continue;
            return;
        }
        Variable configurationVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.configuration);
        Function f = (Function)configurationVariable.getPossiblePropertyValue(graph, SEL.AbstractVariableTabContribution_testFunction);
        if (f != null && !Boolean.TRUE.equals(pass = (Boolean)Simantics.applySCLRead((ReadGraph)graph, (Function)f, (Object[])new Object[]{variable}))) {
            return;
        }
        String viewURI = graph.getPossibleURI(view);
        if (viewURI != null) {
            result.add(new ComparableTabContributor(new ModelledViewTabContributor(viewURI), priority.intValue(), variable, label));
        }
    }
}

