/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.SelectionProcessorBinding;
import org.simantics.selectionview.SelectionProcessorBindingExtension;
import org.simantics.selectionview.SelectionProcessorBindingImpl;
import org.simantics.selectionview.SelectionProcessorImplementationBinding;
import org.simantics.selectionview.SelectionProcessorReferenceBinding;
import org.simantics.utils.strings.StringUtils;

public class SelectionProcessorBindingExtensionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private static final String EP_NAME = "selectionProcessorBinding";
    private ExtensionTracker tracker;
    private SelectionProcessorBindingExtension[] extensions = new SelectionProcessorBindingExtension[0];
    private static SelectionProcessorBindingExtensionManager INSTANCE;

    SelectionProcessorBindingExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new SelectionProcessorBindingExtension[0];
    }

    public SelectionProcessorBindingExtension[] getExtensions() {
        return this.extensions;
    }

    SelectionProcessorReferenceBinding createReferenceBinding(String browseContext, String factoryId) {
        return new SelectionProcessorReferenceBinding(browseContext, factoryId);
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<SelectionProcessorBindingExtension> newExtensions = new HashSet<SelectionProcessorBindingExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionProcessorBindingExtension ext;
            IConfigurationElement child;
            IConfigurationElement el = iConfigurationElementArray[n2];
            String browseContext = OntologyVersions.getInstance().currentVersion(StringUtils.safeString((String)el.getAttribute("browseContext")));
            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren("reference");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                String factoryId = StringUtils.safeString((String)child.getAttribute("id"));
                ext = this.createReferenceBinding(browseContext, factoryId);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                newExtensions.add(ext);
                ++n4;
            }
            iConfigurationElementArray2 = el.getChildren("implementation");
            n3 = iConfigurationElementArray2.length;
            n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                try {
                    SelectionProcessor processor = (SelectionProcessor)child.createExecutableExtension("class");
                    ext = new SelectionProcessorImplementationBinding(browseContext, processor);
                    this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                    newExtensions.add(ext);
                }
                catch (CoreException e) {
                    System.out.println(" == Could not load ViewpointContributionFactory '" + child.getAttribute("class") + "' due to the following error: " + e.getMessage());
                }
                ++n4;
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new SelectionProcessorBindingExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<SelectionProcessorBindingExtension> newExtensions = new HashSet<SelectionProcessorBindingExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new SelectionProcessorBindingExtension[newExtensions.size()]);
    }

    public Set<SelectionProcessorBinding> getBoundContributions(Set<String> browseContexts) {
        HashSet<SelectionProcessorBinding> result = new HashSet<SelectionProcessorBinding>();
        SelectionProcessorBindingExtension[] selectionProcessorBindingExtensionArray = this.getExtensions();
        int n = selectionProcessorBindingExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionProcessor<?, ?> processor;
            SelectionProcessorBindingExtension binding = selectionProcessorBindingExtensionArray[n2];
            if (browseContexts.contains(binding.getBrowseContext()) && (processor = binding.getProcessor()) != null) {
                result.add(new SelectionProcessorBindingImpl(processor));
            }
            ++n2;
        }
        return result;
    }

    public static synchronized SelectionProcessorBindingExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SelectionProcessorBindingExtensionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }
}

