/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.function.Consumer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.IPageBookViewPagePartInit;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.swt.PartNameListener;
import org.simantics.browsing.ui.swt.PropertyPageUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.db.request.Read;
import org.simantics.selectionview.AbstractPropertyPage;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.PropertyTable;
import org.simantics.ui.workbench.IPropertyPage;

public class PropertyPage
extends AbstractPropertyPage
implements IPropertyPage,
IAdaptable,
IPartListener2,
IPageBookViewPagePartInit {
    protected static final int MAX_SELECTION_LENGTH_TO_SHOW = 5;
    protected ISessionContext sessionContext;
    protected IPropertyTab tab;
    protected ISelection latestSelection = StructuredSelection.EMPTY;
    protected IWorkbenchPart propertyPageView;
    protected boolean visible = true;
    protected ISessionContextChangedListener contextChangeListener = new ISessionContextChangedListener(){

        public void sessionContextChanged(SessionContextChangedEvent event) {
            PropertyPage.this.setSessionContext(event.getNewValue());
        }
    };
    protected PartNameListener currentPartNameListener = null;

    public PropertyPage(IWorkbenchPartSite site) {
        super(site);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        if (this.getSite() != null) {
            this.getSite().getPage().addPartListener((IPartListener2)this);
        }
    }

    public void initPart(IWorkbenchPart part) {
        this.propertyPageView = part;
    }

    @Override
    public void dispose() {
        ISessionContextProvider contextProvider;
        if (this.getSite() != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this);
        }
        if (this.currentPartNameListener != null) {
            this.currentPartNameListener.dispose();
            this.currentPartNameListener = null;
        }
        if ((contextProvider = this.getSessionContextProvider()) != null) {
            contextProvider.removeContextChangedListener(this.contextChangeListener);
        }
        super.dispose();
        this.tab = null;
        this.sessionContext = null;
        this.propertyPageView = null;
    }

    protected ISessionContextProvider getSessionContextProvider() {
        return Simantics.getSessionContextProvider();
    }

    protected ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected Session getSession() {
        if (this.sessionContext == null) {
            throw new IllegalStateException("null session context");
        }
        return this.sessionContext.getSession();
    }

    public final void createControl(Composite parent) {
        this.createPageControls(parent);
        ISessionContextProvider contextProvider = this.getSessionContextProvider();
        contextProvider.addContextChangedListener(this.contextChangeListener);
        this.setSessionContext(contextProvider.getSessionContext());
    }

    protected void createPageControls(Composite parent) {
        PropertyTable pt = new PropertyTable((IWorkbenchSite)this.sourceSite, parent, 0);
        this.tab = pt;
        this.tab.createControl(pt, this.getSessionContext());
        this.tab.getControl().addListener(12, new Listener(){

            public void handleEvent(Event event) {
                PropertyPage.this.dispose();
            }
        });
        ISelectionProvider pv = pt.getSelectionProvider();
        this.getSite().setSelectionProvider(pv);
        this.fillToolBar(this.getSite().getActionBars().getToolBarManager());
        this.fillDropDownMenu(this.getSite().getActionBars().getMenuManager());
    }

    protected void fillToolBar(IToolBarManager manager) {
    }

    protected void fillDropDownMenu(IMenuManager manager) {
    }

    protected final void setSessionContext(ISessionContext newContext) {
        this.sessionContext = newContext;
    }

    public Control getControl() {
        return this.tab != null ? this.tab.getControl() : null;
    }

    public ISelection getSelection() {
        ISelectionProvider provider;
        if (this.tab != null && !this.tab.isDisposed() && (provider = this.tab.getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void setFocus() {
        if (this.tab != null && !this.tab.isDisposed()) {
            this.tab.requestFocus();
        }
    }

    @Override
    protected void sourcePartClosed(IWorkbenchPart part) {
        if (this.tab != null && !this.tab.isDisposed()) {
            this.tab.setInput(this.getSessionContext(), (ISelection)StructuredSelection.EMPTY, false);
        }
    }

    @Override
    protected void sourceSelectionChanged(ISelection selection) {
        if (this.tab != null && !this.tab.isDisposed()) {
            this.latestSelection = selection;
            if (this.visible) {
                this.tab.setInput(this.getSessionContext(), selection, false);
            }
        }
    }

    protected void refresh() {
        if (this.tab != null && !this.tab.isDisposed()) {
            this.tab.setInput(this.getSessionContext(), this.latestSelection, true);
        }
    }

    public void updatePartName(final ISelection forSelection, Consumer<String> updateCallback) {
        PartNameListener newListener;
        if (!this.visible) {
            updateCallback.accept("Selection");
            return;
        }
        PartNameListener oldListener = this.currentPartNameListener;
        this.currentPartNameListener = newListener = new PartNameListener(updateCallback);
        if (oldListener != null) {
            oldListener.dispose();
        }
        if (this.sessionContext != null) {
            this.sessionContext.getSession().asyncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return PropertyPage.this.computeTitle(graph, forSelection);
                }
            }, (org.simantics.db.procedure.Listener)newListener);
        }
    }

    protected String computeTitle(ReadGraph graph, ISelection forSelection) throws DatabaseException {
        return PropertyPageUtil.computeTitle((ReadGraph)graph, (ISelection)forSelection);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFilterAreaProvider.class) {
            return (T)this.tab;
        }
        return null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.propertyPageView.equals(part)) {
            this.visible = false;
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.propertyPageView.equals(part)) {
            this.visible = true;
            this.sourceSelectionChanged(this.latestSelection);
        }
    }
}

