package org.simantics.selectionview.ui.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SelectionViewUIResources {
    
    public final Resource CategoryDecorationRule;
    public final Resource CategoryNode;
    public final Resource CategoryNodeLabelRule;
    public final Resource PropertyColumn;
    public final Resource SCLMain;
    public final Resource StandardProperties;
    public final Resource StandardPropertiesBase;
    public final Resource StandardPropertiesBase_BrowseContext;
    public final Resource StandardProperties_BrowseContextStandardChildren;
    public final Resource StandardProperties_BrowseContextStandardChildren_Cat;
    public final Resource StandardProperties_BrowseContextStandardChildren_CatContribution;
    public final Resource StandardProperties_BrowseContextStandardChildren_Sorter;
    public final Resource StandardProperties_BrowseContextStandardChildren_Var;
    public final Resource StandardProperties_BrowseContextWithoutChildren;
    public final Resource StandardPropertySorterRule;
    public final Resource StandardPropertySorterRuleType;
    public final Resource UnitColumn;
    public final Resource ValueColumn;
    public final Resource VariableColoringDecorationRule;
    public final Resource VariableDecorationRule;
    public final Resource VariablePropertyCategoryRule;
    public final Resource VariablePropertyLabelRule;
    public final Resource VariablePropertyModifierRule;
        
    public static class URIs {
        public static final String CategoryDecorationRule = "http://www.simantics.org/SelectionViewUI-1.1/CategoryDecorationRule";
        public static final String CategoryNode = "http://www.simantics.org/SelectionViewUI-1.1/CategoryNode";
        public static final String CategoryNodeLabelRule = "http://www.simantics.org/SelectionViewUI-1.1/CategoryNodeLabelRule";
        public static final String PropertyColumn = "http://www.simantics.org/SelectionViewUI-1.1/PropertyColumn";
        public static final String SCLMain = "http://www.simantics.org/SelectionViewUI-1.1/SCLMain";
        public static final String StandardProperties = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties";
        public static final String StandardPropertiesBase = "http://www.simantics.org/SelectionViewUI-1.1/StandardPropertiesBase";
        public static final String StandardPropertiesBase_BrowseContext = "http://www.simantics.org/SelectionViewUI-1.1/StandardPropertiesBase/BrowseContext";
        public static final String StandardProperties_BrowseContextStandardChildren = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextStandardChildren";
        public static final String StandardProperties_BrowseContextStandardChildren_Cat = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextStandardChildren/Cat";
        public static final String StandardProperties_BrowseContextStandardChildren_CatContribution = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextStandardChildren/CatContribution";
        public static final String StandardProperties_BrowseContextStandardChildren_Sorter = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextStandardChildren/Sorter";
        public static final String StandardProperties_BrowseContextStandardChildren_Var = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextStandardChildren/Var";
        public static final String StandardProperties_BrowseContextWithoutChildren = "http://www.simantics.org/SelectionViewUI-1.1/StandardProperties/BrowseContextWithoutChildren";
        public static final String StandardPropertySorterRule = "http://www.simantics.org/SelectionViewUI-1.1/StandardPropertySorterRule";
        public static final String StandardPropertySorterRuleType = "http://www.simantics.org/SelectionViewUI-1.1/StandardPropertySorterRuleType";
        public static final String UnitColumn = "http://www.simantics.org/SelectionViewUI-1.1/UnitColumn";
        public static final String ValueColumn = "http://www.simantics.org/SelectionViewUI-1.1/ValueColumn";
        public static final String VariableColoringDecorationRule = "http://www.simantics.org/SelectionViewUI-1.1/VariableColoringDecorationRule";
        public static final String VariableDecorationRule = "http://www.simantics.org/SelectionViewUI-1.1/VariableDecorationRule";
        public static final String VariablePropertyCategoryRule = "http://www.simantics.org/SelectionViewUI-1.1/VariablePropertyCategoryRule";
        public static final String VariablePropertyLabelRule = "http://www.simantics.org/SelectionViewUI-1.1/VariablePropertyLabelRule";
        public static final String VariablePropertyModifierRule = "http://www.simantics.org/SelectionViewUI-1.1/VariablePropertyModifierRule";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SelectionViewUIResources(ReadGraph graph) {
        CategoryDecorationRule = getResourceOrNull(graph, URIs.CategoryDecorationRule);
        CategoryNode = getResourceOrNull(graph, URIs.CategoryNode);
        CategoryNodeLabelRule = getResourceOrNull(graph, URIs.CategoryNodeLabelRule);
        PropertyColumn = getResourceOrNull(graph, URIs.PropertyColumn);
        SCLMain = getResourceOrNull(graph, URIs.SCLMain);
        StandardProperties = getResourceOrNull(graph, URIs.StandardProperties);
        StandardPropertiesBase = getResourceOrNull(graph, URIs.StandardPropertiesBase);
        StandardPropertiesBase_BrowseContext = getResourceOrNull(graph, URIs.StandardPropertiesBase_BrowseContext);
        StandardProperties_BrowseContextStandardChildren = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextStandardChildren);
        StandardProperties_BrowseContextStandardChildren_Cat = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextStandardChildren_Cat);
        StandardProperties_BrowseContextStandardChildren_CatContribution = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextStandardChildren_CatContribution);
        StandardProperties_BrowseContextStandardChildren_Sorter = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextStandardChildren_Sorter);
        StandardProperties_BrowseContextStandardChildren_Var = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextStandardChildren_Var);
        StandardProperties_BrowseContextWithoutChildren = getResourceOrNull(graph, URIs.StandardProperties_BrowseContextWithoutChildren);
        StandardPropertySorterRule = getResourceOrNull(graph, URIs.StandardPropertySorterRule);
        StandardPropertySorterRuleType = getResourceOrNull(graph, URIs.StandardPropertySorterRuleType);
        UnitColumn = getResourceOrNull(graph, URIs.UnitColumn);
        ValueColumn = getResourceOrNull(graph, URIs.ValueColumn);
        VariableColoringDecorationRule = getResourceOrNull(graph, URIs.VariableColoringDecorationRule);
        VariableDecorationRule = getResourceOrNull(graph, URIs.VariableDecorationRule);
        VariablePropertyCategoryRule = getResourceOrNull(graph, URIs.VariablePropertyCategoryRule);
        VariablePropertyLabelRule = getResourceOrNull(graph, URIs.VariablePropertyLabelRule);
        VariablePropertyModifierRule = getResourceOrNull(graph, URIs.VariablePropertyModifierRule);
    }
    
    public static SelectionViewUIResources getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SelectionViewUIResources ret = session.peekService(SelectionViewUIResources.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SelectionViewUIResources(qc.getIndependentGraph(graph));
            session.registerService(SelectionViewUIResources.class, ret);
        }
        return ret;
    }
    
    public static SelectionViewUIResources getInstance(RequestProcessor session) throws DatabaseException {
        SelectionViewUIResources ret = session.peekService(SelectionViewUIResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SelectionViewUIResources>() {
                public SelectionViewUIResources perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SelectionViewUIResources(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SelectionViewUIResources.class, ret);
        }
        return ret;
    }
    
}

