/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.debug.SymbolReference;
import org.simantics.scl.db.SCLExpressionTableEntry;
import org.simantics.scl.ui.editor2.OpenSCLDefinition;
import org.simantics.ui.workbench.action.DefaultActions;

public class SCLSearchResultPage
extends AbstractTextSearchViewPage {
    private SCLSearchResultContentProvider contentProvider;
    private static final ViewerComparator comparator = new ViewerComparator(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof SymbolReference && e2 instanceof SymbolReference) {
                SymbolReference r1 = (SymbolReference)e1;
                SymbolReference r2 = (SymbolReference)e2;
                int c = r1.referrer.toString().compareTo(r2.referrer.toString());
                if (c != 0) {
                    return c;
                }
                return Integer.compare(Locations.beginOf((long)r1.referenceLocation), Locations.beginOf((long)r2.referenceLocation));
            }
            if (e1 instanceof SymbolReference && e2 instanceof SCLExpressionTableEntry) {
                return 1;
            }
            if (e2 instanceof SymbolReference && e1 instanceof SCLExpressionTableEntry) {
                return -1;
            }
            SCLExpressionTableEntry r1 = (SCLExpressionTableEntry)e1;
            SCLExpressionTableEntry r2 = (SCLExpressionTableEntry)e2;
            return r1.getContent().compareTo(r2.getContent());
        }
    };

    public SCLSearchResultPage() {
        this.setElementLimit(-1);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.contentProvider = new SCLSearchResultContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setComparator(comparator);
        viewer.setLabelProvider((IBaseLabelProvider)this.contentProvider);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        this.contentProvider = new SCLSearchResultContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setComparator(comparator);
        viewer.setLabelProvider((IBaseLabelProvider)this.contentProvider);
    }

    protected void handleOpen(OpenEvent event) {
        Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
        if (selection != null) {
            this.open(selection);
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
        this.open(match.getElement());
    }

    private void open(Object selection) {
        if (selection instanceof SymbolReference) {
            SymbolReference reference = (SymbolReference)selection;
            OpenSCLDefinition.scheduleOpenDefinition(reference.referrer.module, reference.referenceLocation);
        } else if (selection instanceof SCLExpressionTableEntry) {
            SCLExpressionTableEntry entry = (SCLExpressionTableEntry)selection;
            DefaultActions.performDefaultAction((Control)this.getControl().getDisplay().getActiveShell(), (Object)new StructuredSelection((Object)entry.getResource()));
        }
    }

    public static class SCLSearchResultContentProvider
    extends DecoratingStyledCellLabelProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private Map<Object, Set<Object>> fChildrenMap;
        private AbstractTextSearchResult result;
        private SCLSearchResultPage page;
        protected final Object[] EMPTY_ARR = new Object[0];

        public SCLSearchResultContentProvider(SCLSearchResultPage sclSearchResultPage) {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SCLSearchResultLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), DecorationContext.DEFAULT_CONTEXT);
            this.page = sclSearchResultPage;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.initialize((AbstractTextSearchResult)newInput);
        }

        protected void initialize(AbstractTextSearchResult result) {
            this.result = result;
            this.fChildrenMap = new HashMap<Object, Set<Object>>();
            if (result != null) {
                Object[] elements = result.getElements();
                int i = 0;
                while (i < elements.length) {
                    if (this.getPage().getDisplayedMatchCount(elements[i]) > 0) {
                        this.insert(null, null, elements[i]);
                    }
                    ++i;
                }
            }
        }

        private AbstractTextSearchResult getSearchResult() {
            return this.result;
        }

        public SCLSearchResultPage getPage() {
            return this.page;
        }

        public void elementsChanged(Object[] updatedElements) {
            if (this.getSearchResult() == null) {
                return;
            }
            AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
            HashSet<Object> toRemove = new HashSet<Object>();
            HashSet<Object> toUpdate = new HashSet<Object>();
            HashMap<Object, Set<Object>> toAdd = new HashMap<Object, Set<Object>>();
            for (Map.Entry<Object, Set<Object>> e : this.fChildrenMap.entrySet()) {
                Collection refs = e.getValue();
                refs.forEach(r -> this.remove(toRemove, toUpdate, r));
            }
            int i = 0;
            while (i < updatedElements.length) {
                if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                    this.insert(toAdd, toUpdate, updatedElements[i]);
                } else {
                    this.remove(toRemove, toUpdate, updatedElements[i]);
                }
                ++i;
            }
            viewer.remove(toRemove.toArray());
            for (Object parent : toAdd.keySet()) {
                HashSet children = (HashSet)toAdd.get(parent);
                viewer.add(parent, children.toArray());
            }
            Iterator elementsToUpdate = toUpdate.iterator();
            while (elementsToUpdate.hasNext()) {
                viewer.refresh(elementsToUpdate.next());
            }
        }

        protected void insert(Map<Object, Set<Object>> toAdd, Set<Object> toUpdate, Object child) {
            Object parent = this.getParent(child);
            while (parent != null) {
                if (this.insertChild(parent, child)) {
                    if (toAdd != null) {
                        this.insertInto(parent, child, toAdd);
                    }
                } else {
                    if (toUpdate != null) {
                        toUpdate.add(parent);
                    }
                    return;
                }
                child = parent;
                parent = this.getParent(child);
            }
            if (this.insertChild(this.getSearchResult(), child) && toAdd != null) {
                this.insertInto(this.getSearchResult(), child, toAdd);
            }
        }

        private boolean insertChild(Object parent, Object child) {
            return this.insertInto(parent, child, this.fChildrenMap);
        }

        private boolean insertInto(Object parent, Object child, Map<Object, Set<Object>> map) {
            Set<Object> children = map.get(parent);
            if (children == null) {
                children = new HashSet<Object>();
                map.put(parent, children);
            }
            return children.add(child);
        }

        protected void remove(Set<Object> toRemove, Set<Object> toUpdate, Object element) {
            if (this.hasChildren(element)) {
                if (toUpdate != null) {
                    toUpdate.add(element);
                }
            } else if (this.getPage().getDisplayedMatchCount(element) == 0) {
                this.fChildrenMap.remove(element);
                Object parent = this.getParent(element);
                if (parent != null) {
                    if (this.removeFromSiblings(element, parent)) {
                        this.remove(toRemove, toUpdate, parent);
                    }
                } else if (this.removeFromSiblings(element, this.getSearchResult()) && toRemove != null) {
                    toRemove.add(element);
                }
            } else if (toUpdate != null) {
                toUpdate.add(element);
            }
        }

        private boolean removeFromSiblings(Object element, Object parent) {
            Set<Object> siblings = this.fChildrenMap.get(parent);
            if (siblings != null) {
                return siblings.remove(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            Set<Object> children = this.fChildrenMap.get(parentElement);
            if (children == null) {
                return this.EMPTY_ARR;
            }
            int limit = this.getPage().getElementLimit();
            if (limit != -1 && limit < children.size()) {
                Object[] limitedArray = new Object[limit];
                Iterator<Object> iterator = children.iterator();
                int i = 0;
                while (i < limit) {
                    limitedArray[i] = iterator.next();
                    ++i;
                }
                return limitedArray;
            }
            return children.toArray();
        }

        public boolean hasChildren(Object element) {
            Set<Object> children = this.fChildrenMap.get(element);
            return children != null && !children.isEmpty();
        }

        public String getText(Object element) {
            if (element instanceof SymbolReference) {
                SymbolReference ref = (SymbolReference)element;
                return ref.referrer.toString();
            }
            if (element instanceof SCLExpressionTableEntry) {
                SCLExpressionTableEntry entry = (SCLExpressionTableEntry)element;
                return entry.getContent();
            }
            return "unsupported element " + String.valueOf(element);
        }
    }

    public static class SCLSearchResultLabelProvider
    implements ILabelProvider,
    IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(this.getText(element));
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof SymbolReference) {
                SymbolReference ref = (SymbolReference)element;
                return ref.referrer.toString();
            }
            if (element instanceof SCLExpressionTableEntry) {
                SCLExpressionTableEntry entry = (SCLExpressionTableEntry)element;
                return entry.getContent();
            }
            return "unsupported element " + String.valueOf(element);
        }
    }
}

