package org.simantics.scl.ui.editor.completion;

import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public class SCLEditorTextHover implements ITextHover, ITextHoverExtension, ITextHoverExtension2 {

    private SCLTextEditorEnvironment sclTextEditorEnvironment;
    
    public SCLEditorTextHover(ISourceViewer sourceViewer, SCLTextEditorEnvironment sclTextEditorEnvironment) {
        this.sclTextEditorEnvironment = sclTextEditorEnvironment;
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return findWord(textViewer.getDocument(), offset);
    }
    
    private static IRegion findWord(IDocument document, int offset) {
        int start= -2;
        int end= -1;

        try {

            int pos= offset;
            char c;

            while (pos >= 0) {
                c= document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c))
                    break;
                --pos;
            }

            start= pos;

            pos= offset;
            int length= document.getLength();

            while (pos < length) {
                c= document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c))
                    break;
                ++pos;
            }

            end= pos;

        } catch (BadLocationException x) {
        }

        if (start >= -1 && end > -1) {
            if (start == offset && end == offset)
                return new Region(offset, 0);
            else if (start == offset)
                return new Region(start, end - start);
            else
                return new Region(start + 1, end - start - 1);
        }

        return null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        String info = null;
        try {
            IDocument document = textViewer.getDocument();
            String text = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
            sclTextEditorEnvironment.updateEnvironment(document);
            info = sclTextEditorEnvironment.getHoverInfo(text);
        } catch (BadLocationException e) {
            
        }
        return info;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        AbstractReusableInformationControlCreator creator = new AbstractReusableInformationControlCreator() {
            
            @Override
            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
        return creator;
    }

}
