/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.io;

import gnu.trove.list.array.TByteArrayList;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class SclIO {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static byte readByte(InputStream in) throws IOException {
        int ch1 = in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        return (byte)ch1;
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int ch1 = in.read();
        if (ch1 < 0) {
            throw new EOFException();
        }
        return ch1 != 0;
    }

    public static char readCharacter(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    public static short readShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + ch2);
    }

    public static int readInteger(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static long readLong(InputStream in) throws IOException {
        int ch8;
        int ch7;
        int ch6;
        int ch5;
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read()) | (ch5 = in.read()) | (ch6 = in.read()) | (ch7 = in.read()) | (ch8 = in.read())) < 0) {
            throw new EOFException();
        }
        return ((long)ch1 << 56) + ((long)ch2 << 48) + ((long)ch3 << 40) + ((long)ch4 << 32) + ((long)ch5 << 24) + (long)(ch6 << 16) + (long)(ch7 << 8) + (long)ch8;
    }

    public static float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(SclIO.readInteger(in));
    }

    public static double readDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(SclIO.readLong(in));
    }

    public static int readLength(InputStream in) throws IOException {
        int length = in.read() & 0xFF;
        if (length >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += in.read() << 3;
                        length += in.read() << 11;
                        length += in.read() << 19;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += in.read() << 4;
                        length += in.read() << 12;
                        length += in.read() << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += in.read() << 5;
                    length += in.read() << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += in.read() << 6;
                length += 128;
            }
        }
        return length;
    }

    private static byte[] readFully(InputStream in, int length) throws IOException {
        byte[] result = new byte[length];
        int cur = 0;
        while (cur < length) {
            int c = in.read(result, cur, length - cur);
            if (c <= 0) {
                throw new EOFException();
            }
            cur += c;
        }
        return result;
    }

    public static byte[] readByteArray(InputStream in) throws IOException {
        int length = SclIO.readLength(in);
        return SclIO.readFully(in, length);
    }

    public static double[] readDoubleArray(InputStream in) throws IOException {
        int length = SclIO.readLength(in);
        double[] result = new double[length];
        int i = 0;
        while (i < length) {
            result[i] = SclIO.readDouble(in);
            ++i;
        }
        return result;
    }

    public static String readString(InputStream in) throws IOException {
        return new String(SclIO.readByteArray(in), UTF8);
    }

    public static byte[] readAllByteArrayAndClose(InputStream in) throws IOException {
        try {
            int c;
            TByteArrayList l = new TByteArrayList();
            byte[] buffer = new byte[1024];
            while ((c = in.read(buffer, 0, buffer.length)) > 0) {
                l.add(buffer, 0, c);
            }
            byte[] byArray = l.toArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String readAllStringAndClose(InputStream in) throws IOException {
        return new String(SclIO.readAllByteArrayAndClose(in), UTF8);
    }

    public static void writeByte(OutputStream out, byte v) throws IOException {
        out.write(v);
    }

    public static void writeBoolean(OutputStream out, boolean v) throws IOException {
        out.write(v ? 1 : 0);
    }

    public static void writeCharacter(OutputStream out, char v) throws IOException {
        out.write(v >>> 8);
        out.write(v);
    }

    public static void writeShort(OutputStream out, short v) throws IOException {
        out.write(v >>> 8);
        out.write(v);
    }

    public static void writeInteger(OutputStream out, int v) throws IOException {
        out.write(v >>> 24);
        out.write(v >>> 16);
        out.write(v >>> 8);
        out.write(v);
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((int)(v >>> 56));
        out.write((int)(v >>> 48));
        out.write((int)(v >>> 40));
        out.write((int)(v >>> 32));
        out.write((int)(v >>> 24));
        out.write((int)(v >>> 16));
        out.write((int)(v >>> 8));
        out.write((int)v);
    }

    public static void writeFloat(OutputStream out, float v) throws IOException {
        SclIO.writeInteger(out, Float.floatToRawIntBits(v));
    }

    public static void writeDouble(OutputStream out, double v) throws IOException {
        SclIO.writeLong(out, Double.doubleToRawLongBits(v));
    }

    public static void writeLength(OutputStream out, int length) throws IOException {
        if (length < 128) {
            out.write(length);
        } else if ((length -= 128) < 16384) {
            out.write(length & 0x3F | 0x80);
            out.write(length >>> 6);
        } else if ((length -= 16384) < 0x200000) {
            out.write(length & 0x1F | 0xC0);
            out.write(length >>> 5);
            out.write(length >>> 13);
        } else if ((length -= 0x200000) < 0x10000000) {
            out.write(length & 0xF | 0xE0);
            out.write(length >>> 4);
            out.write(length >>> 12);
            out.write(length >>> 20);
        } else {
            out.write((length -= 0x10000000) & 7 | 0xF0);
            out.write(length >>> 3);
            out.write(length >>> 11);
            out.write(length >>> 19);
            out.write(length >>> 27);
        }
    }

    public static void writeByteArray(OutputStream out, byte[] v) throws IOException {
        SclIO.writeLength(out, v.length);
        out.write(v);
    }

    public static void writeDoubleArray(OutputStream out, double[] v) throws IOException {
        SclIO.writeLength(out, v.length);
        double[] dArray = v;
        int n = v.length;
        int n2 = 0;
        while (n2 < n) {
            double s = dArray[n2];
            SclIO.writeDouble(out, s);
            ++n2;
        }
    }

    public static void writeString(OutputStream out, String v) throws IOException {
        SclIO.writeByteArray(out, v.getBytes(UTF8));
    }

    public static int ioSizeString(String v) {
        return SclIO.ioSizeLength(v.length()) + v.getBytes().length;
    }

    public static int ioSizeLength(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 16512) {
            return 2;
        }
        if (length < 2113664) {
            return 3;
        }
        if (length < 270549120) {
            return 4;
        }
        return 5;
    }
}

