package org.simantics.scl.rest;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLRESTServer {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLRESTServer.class);
    
    private static SCLRESTServer INSTANCE = null;
    private static Server server;
    private static ServiceServerThread serverThread;

    private SCLRESTServer(String token, int preferablePort) {
        ResourceConfig config = new ResourceConfig();
        // JSON serialization/deserialization
        config.register(JacksonFeature.class);
        // File upload
        config.register(MultiPartFeature.class);
        // Actual API
        config.register(SCLRESTAPI.class);
        // Authorization
        config.register(new AuthorizationFilter(token));
        
        ServletHolder holder = new ServletHolder(new ServletContainer(config));
        
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(preferablePort);
        
        server.setConnectors(new Connector[] { connector });
        
        ServletContextHandler context = new ServletContextHandler(server, "/", ServletContextHandler.SESSIONS);
        context.addServlet(holder, "/*");
    }
    
    private static class ServiceServerThread extends Thread {

        @Override
        public void run() {
            try {
                server.start();
                server.join();
            } catch (Exception e) {
                LOGGER.error("Could not start server ", e);
            }
        }
    }

    private static synchronized SCLRESTServer getInstance(String token, int port) {
        try {
            if (INSTANCE == null) {
                INSTANCE = new SCLRESTServer(token, port);
            }
        } catch (Exception e) {
            LOGGER.error("Could not initialize SCL REST server", e);
        }
        return INSTANCE;
    }

    public static synchronized void start(String token, int port) throws Exception {
        // Ensure that an instance is created
        getInstance(token, port);
        if (serverThread == null && server != null) {
            serverThread = new ServiceServerThread();
            serverThread.start();
        }
    }
    
    public static synchronized void stop() throws Exception {
        if (server != null)
            server.stop();
        serverThread = null;
    }
}
