/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.issues;

import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;

public abstract class SCLIssuesTableEntry
implements Comparable<SCLIssuesTableEntry> {
    public final String moduleName;
    public final CompilationError error;

    public SCLIssuesTableEntry(String moduleName, CompilationError error) {
        this.moduleName = moduleName;
        this.error = error;
    }

    public abstract void openLocation();

    @Override
    public int compareTo(SCLIssuesTableEntry o) {
        if (this == o) {
            return 0;
        }
        int cmp = this.error.severity.compareTo((Enum)o.error.severity);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.moduleName.compareTo(o.moduleName);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Locations.compare((long)this.error.location, (long)o.error.location);
        if (cmp != 0) {
            return cmp;
        }
        return this.error.description.compareTo(o.error.description);
    }
}

