package org.simantics.scl.db;

import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteEvents;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;

class WriteResultRequestEvents<T> extends WriteResultRequest<T> implements WriteEvents {

    private SCLContext context;
    private Function f;
    private Object oldGraph;
    private Object[] args;
    
    WriteResultRequestEvents(Function f, Object ... args) {
        this(null, f, args);
    }

    WriteResultRequestEvents(VirtualGraph vg, Function f, Object ... args) {
        super(vg);
        this.f = f;
        this.args = args;
        context = SCLContext.getCurrent();
    }

    @Override
    public T perform(WriteGraph graph) throws DatabaseException {
        SCLContext.push(context);
        oldGraph = context.put(SCLFunctions.GRAPH, graph);
        return (T)f.applyArray(args);
    }

    @Override
    public void afterListeners() {
        context.put(SCLFunctions.GRAPH, oldGraph);
        SCLContext.pop();
    }

}