/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import java.lang.reflect.Field;
import org.simantics.scl.compiler.internal.codegen.writer.ExternalConstant;
import org.simantics.scl.compiler.top.ModuleInitializer;

public class StandardModuleInitializer
implements ModuleInitializer {
    private final String moduleClassName;
    private final ExternalConstant[] externalConstants;

    private StandardModuleInitializer(String moduleClassName, ExternalConstant[] externalConstants) {
        this.moduleClassName = moduleClassName;
        this.externalConstants = externalConstants;
    }

    @Override
    public void initializeModule(ClassLoader classLoader) throws Exception {
        Class<?> clazz = classLoader.loadClass(this.moduleClassName.replace('/', '.'));
        ExternalConstant[] externalConstantArray = this.externalConstants;
        int n = this.externalConstants.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalConstant ec = externalConstantArray[n2];
            Field field = clazz.getField(ec.fieldName);
            field.set(null, ec.value);
            ++n2;
        }
    }

    public static ModuleInitializer create(String moduleClassName, ExternalConstant[] externalConstants) {
        if (externalConstants.length == 0) {
            return null;
        }
        return new StandardModuleInitializer(moduleClassName, externalConstants);
    }
}

