/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.internal;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.simantics.scl.compiler.markdown.inlines.Subject;
import org.simantics.scl.compiler.markdown.internal.Scanner;
import org.simantics.scl.compiler.markdown.nodes.BlockQuoteNode;
import org.simantics.scl.compiler.markdown.nodes.CodeBlockNode;
import org.simantics.scl.compiler.markdown.nodes.DocumentNode;
import org.simantics.scl.compiler.markdown.nodes.ExtensionBlockNode;
import org.simantics.scl.compiler.markdown.nodes.HeaderNode;
import org.simantics.scl.compiler.markdown.nodes.HorizontalRuleNode;
import org.simantics.scl.compiler.markdown.nodes.HtmlNode;
import org.simantics.scl.compiler.markdown.nodes.ItemNode;
import org.simantics.scl.compiler.markdown.nodes.ListNode;
import org.simantics.scl.compiler.markdown.nodes.Node;
import org.simantics.scl.compiler.markdown.nodes.ParagraphNode;
import org.simantics.scl.compiler.markdown.nodes.Reference;

public class MarkdownParser {
    public static final boolean DEBUG = false;
    public static final int CODE_INDENT = 4;
    private DocumentNode root = new DocumentNode();
    private Node current = this.root;
    private StringBuilder detabBuffer = new StringBuilder();
    private Scanner scanner = new Scanner();
    private int lineNumber = 0;
    private THashMap<String, Reference> referenceMap = new THashMap();

    /*
     * Unable to fully structure code
     */
    public DocumentNode parseDocument(Reader reader) throws IOException {
        lineBuffer = new StringBuilder();
        secondNL = 0;
        while (true) {
            block4: {
                if ((c = reader.read()) != -1) break block4;
                this.processLine(lineBuffer);
                if (true) ** GOTO lbl22
            }
            if (c == 10 || c == 13) {
                if (lineBuffer.length() == 0 && c == secondNL) {
                    secondNL = 0;
                    continue;
                }
                this.processLine(lineBuffer);
                lineBuffer.delete(0, lineBuffer.length());
                secondNL = c == 10 ? 13 : 10;
                continue;
            }
            lineBuffer.append((char)c);
        }
        do {
            this.current = this.finalize(this.current);
lbl22:
            // 2 sources

        } while (this.current != null);
        this.processInlines(this.root);
        return this.root;
    }

    public DocumentNode parseDocument(String text) {
        try {
            return this.parseDocument(new StringReader(text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processInlines(Node node) {
        Node child = node.firstChild;
        while (child != null) {
            this.processInlines(child);
            child = child.next;
        }
        if (node instanceof ParagraphNode || node instanceof HeaderNode) {
            Subject.parseInlines(this.referenceMap, node);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processLine(StringBuilder line) {
        block83: {
            ++this.lineNumber;
            line = this.detab(line);
            line.append('\n');
            container = this.root;
            offset = 0;
            blank = false;
            allMatched = true;
            while (container.lastChild != null && container.lastChild.open) {
                container = container.lastChild;
                firstNonspace = offset;
                while ((c = line.charAt(firstNonspace)) == ' ') {
                    ++firstNonspace;
                }
                indent = firstNonspace - offset;
                v0 = blank = c == '\n';
                if (container instanceof BlockQuoteNode) {
                    if (indent <= 3 && c == '>') {
                        offset = firstNonspace + 1;
                        if (line.charAt(offset) == ' ') {
                            ++offset;
                        }
                    } else {
                        allMatched = false;
                    }
                } else if (container instanceof ItemNode) {
                    item = (ItemNode)container;
                    if (indent >= item.indentation) {
                        offset += item.indentation;
                    } else if (blank) {
                        offset = firstNonspace;
                    } else {
                        allMatched = false;
                    }
                } else if (container instanceof CodeBlockNode) {
                    codeBlock = (CodeBlockNode)container;
                    if (!codeBlock.fenced) {
                        if (indent >= 4) {
                            offset += 4;
                        } else if (blank) {
                            offset = firstNonspace;
                        } else {
                            allMatched = false;
                        }
                    } else {
                        if (indent <= 3 && Scanner.isCloseCodeFence(line, firstNonspace, codeBlock.fenceChar, codeBlock.fenceLength)) {
                            this.current = this.finalize(container);
                            return;
                        }
                        i = codeBlock.fenceOffset;
                        while (i > 0 && line.charAt(offset) == ' ') {
                            ++offset;
                            --i;
                        }
                    }
                } else if (container instanceof HeaderNode) {
                    allMatched = false;
                } else if (container instanceof HtmlNode) {
                    if (blank) {
                        allMatched = false;
                    }
                } else if (container instanceof ParagraphNode && blank) {
                    allMatched = false;
                }
                if (allMatched) continue;
                container = container.parent;
                break;
            }
            lastMatchedContainer = container;
            if (blank && container.lastLineBlank) {
                b /* !! */  = this.root;
                while (b /* !! */  != null && !(b /* !! */  instanceof ListNode)) {
                    b /* !! */  = b /* !! */ .lastChild;
                }
                if (b /* !! */  != null) {
                    while (container != null && container != b /* !! */ ) {
                        container = this.finalize(container);
                    }
                    this.finalize(b /* !! */ );
                    container = b /* !! */ .parent;
                }
            }
            maybeLazy = this.current instanceof ParagraphNode;
            while (!(container instanceof CodeBlockNode) && !(container instanceof HtmlNode)) {
                firstNonspace = offset;
                while ((c = line.charAt(firstNonspace)) == ' ') {
                    ++firstNonspace;
                }
                indent = firstNonspace - offset;
                v1 = blank = c == '\n';
                if (indent >= 4) {
                    if (maybeLazy || blank) break;
                    offset += 4;
                    container = this.addChild(container, new CodeBlockNode());
                } else if (c == '>') {
                    offset = firstNonspace + 1;
                    if (line.charAt(offset) == ' ') {
                        ++offset;
                    }
                    container = this.addChild(container, new BlockQuoteNode());
                } else if (c == '#' && this.scanner.isAtxHeaderStart(line, firstNonspace)) {
                    offset = firstNonspace + this.scanner.matched;
                    container = this.addChild(container, new HeaderNode(this.scanner.level, false));
                } else if ((c == '`' || c == '~') && this.scanner.isOpenCodeFence(line, firstNonspace, c)) {
                    container = this.addChild(container, new CodeBlockNode(c, this.scanner.level, firstNonspace - offset));
                    offset = firstNonspace + this.scanner.matched;
                } else if (Scanner.isHtmlBlockTag(line, firstNonspace)) {
                    container = this.addChild(container, new HtmlNode());
                } else if ((c == '=' || c == '-') && container instanceof ParagraphNode && Scanner.isSetextHeaderLine(line, firstNonspace, c)) {
                    header = new HeaderNode(c == '=' ? 1 : 2, true);
                    header.lineNumber = container.lineNumber;
                    header.stringContent = container.stringContent;
                    header.parent = container.parent;
                    header.prev = container.prev;
                    if (header.prev != null) {
                        header.prev.next = header;
                    }
                    if (header.parent.lastChild != null) {
                        header.parent.lastChild = header;
                    }
                    if (header.parent.firstChild == container) {
                        header.parent.firstChild = header;
                    }
                    if (this.current == (container = header)) {
                        this.current = header;
                    }
                    offset = line.length() - 1;
                } else if (!(container instanceof ParagraphNode && !allMatched || c != '*' && c != '_' && c != '-' || !Scanner.isHRule(line, firstNonspace, c))) {
                    container = this.addChild(container, new HorizontalRuleNode());
                    container = this.finalize(container);
                    offset = line.length() - 1;
                } else if (!(c != '*' && c != '+' && c != '-' || line.charAt(firstNonspace + 1) != ' ' && line.charAt(firstNonspace + 1) != '\n')) {
                    originalOffset = offset;
                    offset = firstNonspace + 1;
                    i = 0;
                    c2 = '\u0000';
                    while (i <= 5 && (c2 = line.charAt(offset + i)) == ' ') {
                        ++i;
                    }
                    if (i >= 5 || i < 1 || c2 == '\n') {
                        if (i > 0) {
                            ++offset;
                        }
                    } else {
                        offset += i;
                    }
                    if (!(container instanceof ListNode) || !((ListNode)container).isCompatible(c)) {
                        container = this.addChild(container, new ListNode(c));
                    }
                    container = this.addChild(container, new ItemNode(offset - originalOffset + (i == 0 ? 1 : 0)));
                } else if (Character.isDigit(c) && this.scanner.isListMarker(line, firstNonspace)) {
                    originalOffset = offset;
                    offset = firstNonspace + this.scanner.matched;
                    i = 0;
                    c2 = '\u0000';
                    while (i <= 5 && (c2 = line.charAt(offset + i)) == ' ') {
                        ++i;
                    }
                    if (i >= 5 || i < 1 || c2 == '\n') {
                        if (i > 0) {
                            ++offset;
                        }
                    } else {
                        offset += i;
                    }
                    if (!(container instanceof ListNode) || !((ListNode)container).isCompatible(this.scanner.bulletChar)) {
                        container = this.addChild(container, new ListNode(this.scanner.bulletChar, this.scanner.level));
                    }
                    container = this.addChild(container, new ItemNode(offset - originalOffset + (i == 0 ? 1 : 0)));
                } else {
                    if (c != ':' || line.charAt(firstNonspace + 1) != ':') break;
                    p = firstNonspace + 2;
                    while (Character.isAlphabetic(c = line.charAt(p)) || Character.isDigit(c) || c == ' ' || c == '_') {
                        ++p;
                    }
                    if (c != '[') break;
                    bracketBegin = p++;
                    while ((c = line.charAt(p++)) != ']') {
                        if (c == '\\' && ((c = line.charAt(p + 1)) == '\\' || c == ']')) {
                            ++p;
                            continue;
                        }
                        if (c != '\n') continue;
                    }
                    if (c != ']') break;
                    offset = p;
                    container = this.addChild(container, new ExtensionBlockNode(line.substring(firstNonspace + 2, bracketBegin).trim(), line.substring(bracketBegin + 1, p - 1).trim()));
                }
                if (container.acceptLines()) break;
                maybeLazy = false;
            }
            firstNonspace = offset;
            while ((c = line.charAt(firstNonspace)) == ' ') {
                ++firstNonspace;
            }
            v2 = blank = c == '\n';
            if (blank) {
                if (container.lastChild != null) {
                    container.lastChild.setLastLineBlank(true);
                }
                container.setLastLineBlank(!(container instanceof BlockQuoteNode != false || container instanceof HeaderNode != false || container instanceof CodeBlockNode != false && ((CodeBlockNode)container).fenced != false || container instanceof ItemNode != false && container.firstChild == null && container.lineNumber == this.lineNumber));
            } else {
                container.setLastLineBlank(false);
            }
            cont = container;
            while (cont.parent != null) {
                cont = cont.parent;
                cont.setLastLineBlank(false);
            }
            if (this.current == lastMatchedContainer || container != lastMatchedContainer || blank || !(this.current instanceof ParagraphNode) || this.current.stringContent == null) ** GOTO lbl203
            this.addLine(this.current, line, offset);
            break block83;
lbl-1000:
            // 1 sources

            {
                this.current = this.finalize(this.current);
lbl203:
                // 2 sources

                ** while (this.current != lastMatchedContainer)
            }
lbl204:
            // 1 sources

            if (container instanceof CodeBlockNode || container instanceof HtmlNode) {
                this.addLine(container, line, offset);
            } else if (!blank) {
                if (container.acceptLines()) {
                    if (container instanceof HeaderNode && !((HeaderNode)container).setext) {
                        this.chopTrailingHashtags(line, firstNonspace);
                    }
                    this.addLine(container, line, firstNonspace);
                } else {
                    container = this.addChild(container, new ParagraphNode());
                    this.addLine(container, line, firstNonspace);
                }
            }
            this.current = container;
        }
    }

    private void chopTrailingHashtags(StringBuilder line, int firstNonspace) {
        int pos = line.length() - 1;
        char c = '\u0000';
        while (pos >= 0 && ((c = line.charAt(pos)) == ' ' || c == '\n')) {
            --pos;
        }
        line.delete(pos + 1, line.length());
        if (c == '#') {
            --pos;
            while (pos >= 0 && (c = line.charAt(pos)) == '#') {
                --pos;
            }
            if (c != ' ') {
                return;
            }
            --pos;
            while (pos >= 0 && line.charAt(pos) == ' ') {
                --pos;
            }
            if (++pos < firstNonspace) {
                pos = firstNonspace;
            }
            line.delete(pos, line.length());
        }
    }

    private void addLine(Node container, StringBuilder line, int offset) {
        if (container.stringContent == null) {
            container.stringContent = new StringBuilder();
        } else {
            container.stringContent.append('\n');
        }
        int length = line.length();
        if (length > 0 && line.charAt(length - 1) == '\n') {
            --length;
        }
        container.stringContent.append(line, offset, length);
    }

    private StringBuilder detab(StringBuilder str) {
        int length = str.length();
        int i = 0;
        while (i < length) {
            if (str.charAt(i) == '\t') {
                this.detabBuffer.delete(0, this.detabBuffer.length());
                this.detabBuffer.append(str, 0, i);
                while (i < length) {
                    char c = str.charAt(i);
                    if (c == '\t') {
                        int spaces = 4 - this.detabBuffer.length() % 4;
                        while (spaces-- > 0) {
                            this.detabBuffer.append(' ');
                        }
                    } else {
                        this.detabBuffer.append(c);
                    }
                    ++i;
                }
                return this.detabBuffer;
            }
            ++i;
        }
        return str;
    }

    private Node addChild(Node parent, Node child) {
        child.lineNumber = this.lineNumber;
        while (!parent.canContain(child)) {
            parent = this.finalize(parent);
        }
        parent.addChild(child);
        return child;
    }

    private Node finalize(Node node) {
        node.open = false;
        if (node instanceof ParagraphNode) {
            this.parseReferenceInline(node);
        } else if (node instanceof HeaderNode) {
            if (node.stringContent == null) {
                node.stringContent = new StringBuilder(0);
            }
        } else if (node instanceof CodeBlockNode) {
            CodeBlockNode codeBlock = (CodeBlockNode)node;
            if (codeBlock.fenced) {
                String infoString;
                int firstLineLength = codeBlock.stringContent.indexOf("\n");
                if (firstLineLength == -1) {
                    infoString = codeBlock.stringContent.toString().trim();
                    codeBlock.stringContent = new StringBuilder(0);
                } else {
                    infoString = codeBlock.stringContent.substring(0, firstLineLength).trim();
                    codeBlock.stringContent.delete(0, firstLineLength + 1);
                }
                codeBlock.infoString = Reference.cleanUrl(infoString);
            } else {
                MarkdownParser.removeTrailingBlankLines(codeBlock.stringContent);
            }
        } else if (node instanceof ListNode) {
            ListNode list = (ListNode)node;
            list.tight = true;
            Node item = list.firstChild;
            block0: while (item != null) {
                if (item.lastLineBlank && item.next != null) {
                    list.tight = false;
                    break;
                }
                Node child = item.firstChild;
                while (child != null) {
                    if (MarkdownParser.endsWithBlankLine(child) && (child.next != null || item.next != null)) {
                        list.tight = false;
                        break block0;
                    }
                    child = child.next;
                }
                item = item.next;
            }
        }
        return node.parent;
    }

    private static boolean endsWithBlankLine(Node node) {
        do {
            if (!node.lastLineBlank) continue;
            return true;
        } while ((node = node.lastChild) instanceof ListNode || node instanceof ItemNode);
        return false;
    }

    private static void removeTrailingBlankLines(StringBuilder str) {
        int endPos = str.length();
        int pos = endPos - 1;
        while (pos >= 0) {
            char c = str.charAt(pos);
            if (c == '\n') {
                endPos = pos;
            } else if (c != ' ') break;
            --pos;
        }
        if (endPos < str.length()) {
            str.delete(endPos, str.length());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseReferenceInline(Node node) {
        input = node.stringContent;
        while (true) {
            block15: {
                block14: {
                    if ((offset = 0) == input.length() || input.charAt(offset) != '[') {
                        return;
                    }
                    if ((offset = Scanner.scanLinkLabel(input, offset)) == -1 || offset == input.length() || input.charAt(offset) != ':') {
                        return;
                    }
                    label = input.substring(1, offset - 1);
                    ++offset;
                    linkStart = offset = MarkdownParser.spnl(input, offset);
                    if ((offset = Scanner.scanLinkUrl(input, offset)) == -1 || offset == linkStart) {
                        return;
                    }
                    url = linkStart < input.length() && input.charAt(linkStart) == '<' ? input.substring(linkStart + 1, offset - 1) : input.substring(linkStart, offset);
                    url = Reference.cleanUrl(url);
                    linkUrlEnd = offset;
                    titleStart = offset = MarkdownParser.spnl(input, offset);
                    if ((offset = Scanner.scanLinkTitle(input, offset)) != -1) break block14;
                    offset = linkUrlEnd;
                    c = 0;
                    if (true) ** GOTO lbl22
                    do {
                        ++offset;
lbl22:
                        // 2 sources

                        if (offset >= input.length()) break;
                        v0 = input.charAt(offset);
                        c = v0;
                    } while (v0 == ' ');
                    if (c == 10) {
                        ++offset;
                    } else if (offset != input.length()) {
                        return;
                    }
                    title = "";
                    break block15;
                }
                title = input.substring(titleStart + 1, offset - 1);
                title = Reference.cleanTitle(title);
                c = 0;
                if (true) ** GOTO lbl40
                do {
                    ++offset;
lbl40:
                    // 2 sources

                    if (offset >= input.length()) break;
                    v1 = input.charAt(offset);
                    c = v1;
                } while (v1 == ' ');
                if (c == 10) {
                    ++offset;
                } else if (offset != input.length()) {
                    return;
                }
            }
            reference = new Reference(Reference.normalizeLabel(label), url, title);
            if (!this.referenceMap.contains((Object)reference.label)) {
                this.referenceMap.put((Object)reference.label, (Object)reference);
            }
            if (offset == input.length()) {
                node.remove();
                return;
            }
            input.delete(0, offset);
        }
    }

    private static int spnl(StringBuilder input, int offset) {
        boolean seenWhitespace = false;
        while (offset < input.length()) {
            char c = input.charAt(offset);
            if (c == ' ') {
                ++offset;
                continue;
            }
            if (c == '\n') {
                if (seenWhitespace) {
                    return offset;
                }
                seenWhitespace = true;
                ++offset;
                continue;
            }
            return offset;
        }
        return offset;
    }
}

