/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.html;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class HierarchicalDocumentationRef
implements Comparable<HierarchicalDocumentationRef> {
    final String name;
    final ArrayList<HierarchicalDocumentationRef> children = new ArrayList();
    String documentationName;

    public HierarchicalDocumentationRef(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentationName() {
        return this.documentationName;
    }

    public List<HierarchicalDocumentationRef> getChildren() {
        return this.children;
    }

    @Override
    public int compareTo(HierarchicalDocumentationRef o) {
        return this.name.compareTo(o.name);
    }

    public static HierarchicalDocumentationRef generateTree(ModuleSourceRepository sourceRepository) {
        final THashMap refMap = new THashMap();
        HierarchicalDocumentationRef root = new HierarchicalDocumentationRef("");
        refMap.put((Object)"", (Object)root);
        final THashSet documentationPaths = new THashSet();
        TObjectProcedure<String> collector = new TObjectProcedure<String>(){

            public boolean execute(String path) {
                documentationPaths.add((Object)path);
                return true;
            }
        };
        sourceRepository.forAllDocumentations(collector);
        sourceRepository.forAllModules(collector);
        documentationPaths.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            HierarchicalDocumentationRef getRef(String path) {
                HierarchicalDocumentationRef ref = (HierarchicalDocumentationRef)refMap.get((Object)path);
                if (ref == null) {
                    String parentName;
                    String name;
                    int p = path.lastIndexOf(47);
                    if (p >= 0) {
                        name = path.substring(p + 1);
                        parentName = path.substring(0, p);
                    } else {
                        name = path;
                        parentName = "";
                    }
                    ref = new HierarchicalDocumentationRef(name);
                    refMap.put((Object)path, (Object)ref);
                    this.getRef((String)parentName).children.add(ref);
                }
                return ref;
            }

            public boolean execute(String documentationName) {
                this.getRef((String)(documentationName.contains((CharSequence)"/") ? documentationName : new StringBuilder((String)"StandardLibrary/").append((String)documentationName).toString())).documentationName = documentationName;
                return true;
            }
        });
        root.sort();
        return root;
    }

    private void sort() {
        Collections.sort(this.children);
        for (HierarchicalDocumentationRef child : this.children) {
            child.sort();
        }
    }
}

