/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.utils;

import gnu.trove.list.array.TIntArrayList;
import org.simantics.scl.compiler.internal.parsing.utils.LineLocator;

public class LineLocators {
    public static final LineLocator DUMMY_LOCATOR = new LineLocator(new int[1]){

        @Override
        public int lineNumberFromPosition(int position) {
            return 0;
        }
    };

    private static int[] findRowStarts(String source) {
        TIntArrayList rowStarts = new TIntArrayList();
        rowStarts.add(0);
        int length = source.length();
        int i = 0;
        while (i < length) {
            char c = source.charAt(i);
            if (c == '\n') {
                rowStarts.add(i + 1);
            }
            ++i;
        }
        return rowStarts.toArray();
    }

    public static LineLocator createLineLocator(String source) {
        int[] rowStarts = LineLocators.findRowStarts(source);
        if (rowStarts.length <= 127) {
            return new ByteArrayLineLocator(rowStarts);
        }
        if (rowStarts.length <= 65535) {
            return new CharArrayLineLocator(rowStarts);
        }
        return new InterpolationSearchLineLocator(rowStarts);
    }

    private static class BinarySearchLineLocator
    extends LineLocator {
        public BinarySearchLineLocator(int[] rowStarts) {
            super(rowStarts);
        }

        @Override
        public int lineNumberFromPosition(int position) {
            if (position <= 0) {
                return 0;
            }
            if (position >= this.rowStarts[this.rowStarts.length - 1]) {
                return this.rowStarts.length - 1;
            }
            int low = 0;
            int high = this.rowStarts.length - 1;
            while (low < high - 1) {
                int middle = (low + high) / 2;
                if (position < this.rowStarts[middle]) {
                    high = middle;
                    continue;
                }
                low = middle;
            }
            return low;
        }
    }

    private static class ByteArrayLineLocator
    extends LineLocator {
        private final byte[] lineNumbers;
        private final int maxLine;

        public ByteArrayLineLocator(int[] rowStarts) {
            super(rowStarts);
            int lastRow = rowStarts.length - 1;
            this.lineNumbers = new byte[rowStarts[lastRow]];
            this.maxLine = rowStarts.length - 1;
            int position = 0;
            int line = 0;
            while (line < this.maxLine) {
                int endPosition = rowStarts[line + 1];
                while (position < endPosition) {
                    this.lineNumbers[position++] = (byte)line;
                }
                ++line;
            }
        }

        @Override
        public int lineNumberFromPosition(int position) {
            if (position <= 0) {
                return 0;
            }
            if (position >= this.lineNumbers.length) {
                return this.maxLine;
            }
            return this.lineNumbers[position];
        }
    }

    private static class CharArrayLineLocator
    extends LineLocator {
        private final char[] lineNumbers;
        private final int maxLine;

        public CharArrayLineLocator(int[] rowStarts) {
            super(rowStarts);
            int lastRow = rowStarts.length - 1;
            this.lineNumbers = new char[rowStarts[lastRow]];
            this.maxLine = rowStarts.length - 1;
            int position = 0;
            int line = 0;
            while (line < this.maxLine) {
                int endPosition = rowStarts[line + 1];
                while (position < endPosition) {
                    this.lineNumbers[position++] = (char)line;
                }
                ++line;
            }
        }

        @Override
        public int lineNumberFromPosition(int position) {
            if (position <= 0) {
                return 0;
            }
            if (position >= this.lineNumbers.length) {
                return this.maxLine;
            }
            return this.lineNumbers[position];
        }
    }

    private static class IntArrayLineLocator
    extends LineLocator {
        private final int[] lineNumbers;
        private final int maxLine;

        public IntArrayLineLocator(int[] rowStarts) {
            super(rowStarts);
            int lastRow = rowStarts.length - 1;
            this.lineNumbers = new int[rowStarts[lastRow]];
            this.maxLine = rowStarts.length - 1;
            int position = 0;
            int line = 0;
            while (line < this.maxLine) {
                int endPosition = rowStarts[line + 1];
                while (position < endPosition) {
                    this.lineNumbers[position++] = line;
                }
                ++line;
            }
        }

        @Override
        public int lineNumberFromPosition(int position) {
            if (position <= 0) {
                return 0;
            }
            if (position >= this.lineNumbers.length) {
                return this.maxLine;
            }
            return this.lineNumbers[position];
        }
    }

    private static class InterpolationSearchLineLocator
    extends LineLocator {
        public InterpolationSearchLineLocator(int[] rowStarts) {
            super(rowStarts);
        }

        @Override
        public int lineNumberFromPosition(int position) {
            if (position <= 0) {
                return 0;
            }
            if (position >= this.rowStarts[this.rowStarts.length - 1]) {
                return this.rowStarts.length - 1;
            }
            int low = 0;
            int lowPosition = 0;
            int high = this.rowStarts.length - 1;
            int highPosition = this.rowStarts[high];
            while (low < high - 1) {
                int delta = (int)((long)(high - low) * (long)(position - lowPosition) / (long)(highPosition - lowPosition));
                int middle = low + delta;
                if (middle == low) {
                    ++middle;
                }
                if (position < this.rowStarts[middle]) {
                    high = middle;
                    highPosition = this.rowStarts[high];
                    continue;
                }
                low = middle;
                lowPosition = this.rowStarts[low];
            }
            return low;
        }
    }
}

