/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.references;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.references.ValSpecialization;
import org.simantics.scl.compiler.internal.codegen.types.BTypes;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public abstract class Val
implements IVal {
    public static final Val[] EMPTY_ARRAY = new Val[0];
    transient ValRef occurrence;

    @Override
    public final ValRef createOccurrence() {
        return new ValRef(this, Type.EMPTY_ARRAY);
    }

    @Override
    public final ValRef createOccurrence(Type ... parameters) {
        return new ValRef(this, parameters);
    }

    @Override
    public IVal createSpecialization(Type ... parameters) {
        return new ValSpecialization(this, parameters);
    }

    public final void replaceBy(ValRef other) {
        if (other.parameters.length == 0) {
            this.replaceBy(other.binding);
        } else {
            this.replaceBy(other.binding, other.parameters);
        }
    }

    public final ValRef getOccurrence() {
        return this.occurrence;
    }

    public void replaceBy(Val other) {
        ValRef cur = this.occurrence;
        if (cur != null) {
            while (true) {
                if (SCLCompilerConfiguration.DEBUG && cur.binding != this) {
                    throw new InternalCompilerError("Invalid ValRef encountered when replacing " + this + " by " + other + ".");
                }
                cur.binding = other;
                cur.updateParentEffect();
                if (cur.next == null) break;
                cur = cur.next;
            }
            cur.next = other.occurrence;
            if (other.occurrence != null) {
                other.occurrence.prev = cur;
            }
            other.occurrence = this.occurrence;
            this.occurrence = null;
        }
    }

    private void replaceBy(Val other, Type[] parameters) {
        if (other == this || other == null) {
            throw new InternalCompilerError();
        }
        ValRef cur = this.occurrence;
        if (cur != null) {
            while (true) {
                if (SCLCompilerConfiguration.DEBUG && cur.binding != this) {
                    throw new InternalCompilerError("Invalid ValRef encountered when replacing " + this + " by " + other + ".");
                }
                cur.binding = other;
                cur.parameters = Types.concat(parameters, cur.parameters);
                cur.updateParentEffect();
                if (cur.next == null) break;
                cur = cur.next;
            }
            cur.next = other.occurrence;
            if (other.occurrence != null) {
                other.occurrence.prev = cur;
            }
            other.occurrence = this.occurrence;
            this.occurrence = null;
        }
    }

    public void replaceBy(Val other, TVar[] from, Type[] to) {
        if (other == this || other == null) {
            throw new InternalCompilerError();
        }
        if (from.length == 0) {
            this.replaceBy(other, to);
        } else {
            ValRef cur = this.occurrence;
            if (cur != null) {
                while (true) {
                    if (SCLCompilerConfiguration.DEBUG && cur.binding != this) {
                        throw new InternalCompilerError("Invalid ValRef encountered when replacing " + this + " by " + other + ".");
                    }
                    cur.binding = other;
                    cur.parameters = Types.replace(to, from, cur.parameters);
                    cur.updateParentEffect();
                    if (cur.next == null) break;
                    cur = cur.next;
                }
                cur.next = other.occurrence;
                if (other.occurrence != null) {
                    other.occurrence.prev = cur;
                }
                other.occurrence = this.occurrence;
                this.occurrence = null;
            }
        }
    }

    @Override
    public abstract Type getType();

    public final int occurrenceCount() {
        int count = 0;
        ValRef ref = this.occurrence;
        while (ref != null) {
            ++count;
            ref = ref.getNext();
        }
        return count;
    }

    public final boolean hasMoreThanOneOccurences() {
        return this.occurrence != null && this.occurrence.getNext() != null;
    }

    public final boolean hasNoOccurences() {
        return this.occurrence == null;
    }

    public abstract Val copy(THashMap<TVar, TVar> var1);

    public ValRef[] getOccurences() {
        int count = this.occurrenceCount();
        if (count == 0) {
            return ValRef.EMPTY_ARRAY;
        }
        ValRef[] result = new ValRef[count];
        ValRef cur = this.occurrence;
        int i = 0;
        while (i < count) {
            result[i] = cur;
            ++i;
            cur = cur.getNext();
        }
        return result;
    }

    public abstract int getEffectiveArity();

    @Override
    public Type apply(MethodBuilder mb, Type[] typeParameters, Val ... parameters) {
        Type returnType;
        this.push(mb);
        if (parameters.length == 0) {
            return this.getType();
        }
        try {
            returnType = BTypes.matchFunction(this.getType(), parameters.length)[parameters.length];
        }
        catch (MatchException matchException) {
            throw new InternalCompilerError();
        }
        mb.pushBoxed(parameters);
        mb.genericApply(parameters.length);
        mb.unbox(returnType);
        return returnType;
    }

    @Override
    public void setLabel(String label) {
    }

    public void prepare(MethodBuilder mb) {
    }
}

