/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.errors;

import java.io.PrintStream;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.CompilationErrorFormatter;
import org.simantics.scl.compiler.errors.Failable;

public class Failure
implements Failable {
    public final CompilationError[] errors;

    public Failure(CompilationError[] errors) {
        this.errors = errors;
    }

    public Failure(String description) {
        this.errors = new CompilationError[]{new CompilationError(description)};
    }

    public Failure(Exception e) {
        this.errors = new CompilationError[]{new CompilationError(e)};
    }

    public void printTo(PrintStream out) {
        CompilationError[] compilationErrorArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationError error = compilationErrorArray[n2];
            out.println(error.description);
            ++n2;
        }
    }

    public String toString(String source) {
        return CompilationErrorFormatter.toString(source, this.errors);
    }

    public String toString() {
        return CompilationErrorFormatter.toString(this.errors);
    }

    public Object getResult() {
        throw new IllegalStateException("Module compilation failed.");
    }

    @Override
    public boolean didSucceed() {
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Module compilation failed:");
        CompilationError[] compilationErrorArray = this.errors;
        int n = this.errors.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationError error = compilationErrorArray[n2];
            b.append("\n    ").append(error.description);
            ++n2;
        }
        return b.toString();
    }
}

