/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.planning.items;

import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.chr.plan.CheckOp;
import org.simantics.scl.compiler.elaboration.chr.plan.IterateListOp;
import org.simantics.scl.compiler.elaboration.chr.planning.PrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.QueryPlanningContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;

public class MemberPrePlanItem
extends PrePlanItem {
    public Expression expression1;
    public Expression expression2;
    public TIntHashSet variableSet1;
    public TIntHashSet variableSet2;

    public MemberPrePlanItem(Expression expression1, Expression expression2, TIntHashSet variableSet1, TIntHashSet variableSet2, int secondaryPriority) {
        super(secondaryPriority);
        this.expression1 = expression1;
        this.expression2 = expression2;
        this.variableSet1 = variableSet1;
        this.variableSet2 = variableSet2;
        this.updatePrimaryPriority();
    }

    private void updatePrimaryPriority() {
        if (this.variableSet2.isEmpty()) {
            this.primaryPriority = this.variableSet1.isEmpty() ? 0.0 : 2.0;
        }
    }

    @Override
    public void initializeListeners(QueryPlanningContext context) {
        context.listen(this.variableSet1, (PrePlanItem)this);
        context.listen(this.variableSet2, (PrePlanItem)this);
    }

    @Override
    public void variableSolved(QueryPlanningContext context, int variableId) {
        this.variableSet1.remove(variableId);
        this.variableSet2.remove(variableId);
        this.updatePrimaryPriority();
        context.priorityQueue.adjust(this);
    }

    @Override
    public void generate(QueryPlanningContext context) {
        if (!this.variableSet2.isEmpty()) {
            throw new InternalCompilerError("Unsolvable query.");
        }
        if (this.variableSet1.isEmpty()) {
            context.addPlanOp(new CheckOp(this.location, new EApply(this.location, (Expression)new EConstant(context.getCompilationContext().getValue(Names.Prelude_elem)), this.expression1, this.expression2)));
        } else {
            context.addPlanOp(new IterateListOp(this.location, ((EVariable)this.expression1).getVariable(), this.expression2));
        }
        context.bind(this.variableSet1);
    }
}

