package org.simantics.scl.compiler.module.coverage;

import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.runtime.profiling.BranchPoint;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;

public class CoverageBuilder {
    THashMap<String, THashMap<String, BranchPoint[]>> combined =
            new THashMap<String, THashMap<String, BranchPoint[]>>();
    
    public void addCoverage(Module module, boolean persistOverBranchpointReset) {
        THashMap<String, BranchPoint[]> branchPointMap = module.getBranchPoints();
        if(branchPointMap == null)
            return;
        THashMap<String, BranchPoint[]> oldBranchPointMap = combined.get(module.getName());
        if(oldBranchPointMap == null) {
            oldBranchPointMap = new THashMap<String, BranchPoint[]>();
            combined.put(module.getName(), oldBranchPointMap);
        }
        THashMap<String, BranchPoint[]> oldBranchPointMap_ = oldBranchPointMap;
        branchPointMap.forEachEntry(new TObjectObjectProcedure<String, BranchPoint[]>() {
            @Override
            public boolean execute(String name, BranchPoint[] branchPoints) {
                BranchPoint[] oldBranchPoints = oldBranchPointMap_.get(name);
                if(oldBranchPoints == null) {
                    if (persistOverBranchpointReset) {
                        // Clone the branchPoints array so that if will last over a reset
                        BranchPoint[] clonedBranchPoints = cloneBranchPoints(branchPoints);
                        oldBranchPointMap_.put(name, clonedBranchPoints);
                    } else {
                        // No need to copy so resetting branchpoints will reset this as well
                        oldBranchPointMap_.put(name, branchPoints);
                    }
                } else {
                    combineCounters(oldBranchPoints, branchPoints);
                }
                return true;
            }
        });
    }
    
    private static BranchPoint[] cloneBranchPoints(BranchPoint[] oldBranchPoints) {
        BranchPoint[] newBranchPoints = new BranchPoint[oldBranchPoints.length];
        for (int i = 0; i < oldBranchPoints.length; i++) {
            BranchPoint bp = oldBranchPoints[i];
            BranchPoint[] children = cloneBranchPoints(bp.getChildren());
            newBranchPoints[i] = new BranchPoint(bp.getLocation(), bp.getCodeSize(), children);
        }
        return newBranchPoints;
    }
    
    private static void combineCounters(BranchPoint[] oldBranchPoints, BranchPoint[] branchPoints) {
        if(oldBranchPoints.length != branchPoints.length)
            throw new IllegalArgumentException("Incompatible branch points.");
        for(int i=0;i<branchPoints.length;++i) {
            BranchPoint oldBP = oldBranchPoints[i];
            BranchPoint newBP = branchPoints[i];
            if(oldBP.getLocation() != newBP.getLocation())
                throw new IllegalArgumentException("Incompatible branch points.");
            oldBP.incrementVisitCounter(newBP.getVisitCounter());
            combineCounters(oldBP.getChildren(), newBP.getChildren());
        }
    }
    
    public CombinedCoverage getCoverage() {
        THashMap<String,ModuleCoverage> moduleCoverages =
                new THashMap<String,ModuleCoverage>();
        combined.forEachEntry(new TObjectObjectProcedure<String, THashMap<String, BranchPoint[]>>() {
            @Override
            public boolean execute(String name, THashMap<String, BranchPoint[]> branchPoints) {
                moduleCoverages.put(name, CoverageUtils.getCoverage(name, branchPoints));
                return true;
            }
        });
        return CoverageUtils.combineCoverages(moduleCoverages);
    }
}
