package org.simantics.scl.compiler.markdown.internal;

public class CharacterSet {
    private int minChar;
    private int maxChar;
    boolean[] table;
    
    public CharacterSet(String chars) {
        if(chars.isEmpty())
            throw new IllegalArgumentException();
        minChar = Integer.MAX_VALUE;
        maxChar = Integer.MIN_VALUE;
        for(int i=0;i<chars.length();++i) {
            int c = (int)chars.charAt(i);
            if(c == '-' && i > 0 && i < chars.length()-1)
                continue;
            minChar = Math.min(minChar, c);
            maxChar = Math.max(maxChar, c);
        }
        
        table = new boolean[maxChar-minChar+1];
        for(int i=0;i<chars.length();++i) {
            int c = (int)chars.charAt(i);
            if(i < chars.length()-2 && chars.charAt(i+1)=='-') {
                int c2 = (int)chars.charAt(i+2);
                if(c > c2) {
                    int temp = c;
                    c = c2;
                    c2 = temp;
                }
                for(int j=c;j<=c2;++j)
                    table[j - minChar] = true;
                i+=2;
            }
            else 
                table[c - minChar] = true;
        }
    }
    
    public boolean contains(char c_) {
        int c = (int)c_;
        return c >= minChar && c <= maxChar && table[c - minChar];
    }
}
