package org.simantics.scl.compiler.internal.elaboration.matching2;


import java.util.Arrays;

import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;

public class Row2 {
    Expression[] patterns;
    ICont continuation;
    
    public Row2(Expression[] patterns,ICont continuation) {
        this.patterns = patterns;
        this.continuation = continuation;
    }
    
    public Row2 replace(int columnToReplace, Expression[] substitution) {
        Expression[] newPatterns = new Expression[patterns.length-1+substitution.length];
        int j=0;
        for(int i=0;i<columnToReplace;++i)
            newPatterns[j++] = patterns[i];
        for(int i=0;i<substitution.length;++i)
            newPatterns[j++] = substitution[i];
        for(int i=columnToReplace+1;i<patterns.length;++i)
            newPatterns[j++] = patterns[i];
        return new Row2(newPatterns, continuation);
    }
    
    @Override
    public String toString() {
        return Arrays.toString(patterns);
    }
}
