package org.simantics.scl.compiler.internal.codegen.types;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.kinds.Kind;

public class StandardTypeConstructor extends TypeConstructor {
    private TypeDesc typeDesc; // null, if trivial data type (one constructor with one parameter)
    public boolean external; // this means that the class don't need to be generated
    
    public StandardTypeConstructor(TCon con, Kind kind) {
        super(con, kind);
    }
    
    public StandardTypeConstructor(TCon con, Kind kind, TypeDesc typeDesc) {
        this(con, kind);
        this.typeDesc = typeDesc;
    }
    
    public StandardTypeConstructor(TCon con, Kind kind, TypeDesc typeDesc, String documentation) {
        this(con, kind);
        this.typeDesc = typeDesc;
        this.documentation = documentation;
    }
    
    public StandardTypeConstructor(TCon name, TVar[] parameters, TypeDesc typeDesc) {
        super(name, parameters);
        this.typeDesc = typeDesc;
    }

    public void setTypeDesc(TypeDesc typeDesc) {
        this.typeDesc = typeDesc;
    }
    
    public TypeDesc getTypeDesc() {
        return typeDesc;
    }

    @Override
    public TypeDesc construct(JavaTypeTranslator translator, Type[] parameters) {
        if(typeDesc == null)
            typeDesc = translator.toTypeDesc(constructors[0].parameterTypes[0]);
        return typeDesc;
    }
}
