package org.simantics.scl.compiler.internal.codegen.continuations;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;

public class BranchRef {
    public Constant constructor;
    public ContRef cont;
    
    public BranchRef(Constant constructor, ContRef cont) {
        this.constructor = constructor;
        this.cont = cont;
    }
    
    public static BranchRef toBranchRef(Branch branch) {
        return new BranchRef(branch.constructor, branch.cont.createOccurrence());
    }
    
    public static BranchRef[] toBranchRefs(Branch[] branches) {
        BranchRef[] result = new BranchRef[branches.length];
        for(int i=0;i<branches.length;++i)
            result[i] = toBranchRef(branches[i]);
        return result;        
    }
    
    public BranchRef copy(CopyContext context) {
        return new BranchRef(constructor, context.copy(cont));
    }
    
    public static BranchRef[] copy(CopyContext context, BranchRef[] src) {
        BranchRef[] tgt = new BranchRef[src.length];
        for(int i=0;i<src.length;++i)
            tgt[i] = src[i].copy(context);
        return tgt;
    }
}
