package org.simantics.scl.compiler.errors;


public class Success<T> implements Failable<T> {
    public final T result;

    public Success(T result) {
        this.result = result;
    }
    
    @Override
    public T getResult() {
        return result;
    }

    @Override
    public boolean didSucceed() {
        return true;
    }
    
    @Override
    public String toString() {
        return "Success";
    }

    @Override
    public String getDescription() {
        return "Module compilation succeeded.";
    }
}
