package org.simantics.scl.compiler.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.module.Module;

import gnu.trove.map.hash.THashMap;

public class ConcreteEnvironment extends AbstractEnvironment {

    private final THashMap<String, Module> moduleMap;
    private final Namespace localNamespace;
    
    public ConcreteEnvironment(THashMap<String, Module> moduleMap,
            Namespace localNamespace) {
        this.moduleMap = moduleMap;
        this.localNamespace = localNamespace;
    }

    @Override
    public List<Constant> getFieldAccessors(String name) {
        List<Constant> result = null;
        boolean resultIsImmutable = true;
        for(Module module : moduleMap.values()) {
            List<Constant> accessors = module.getFieldAccessors(name);
            if(accessors != null) {
                if(result == null)
                    result = accessors;
                else if(resultIsImmutable) {
                    result = new ArrayList<Constant>(result.size() + accessors.size());
                    result.addAll(accessors);
                    resultIsImmutable = false;
                }   
                else
                    result.addAll(accessors);
            }
        }
        return result;
    }

    @Override
    public Namespace getLocalNamespace() {
        return localNamespace;
    }

    @Override
    protected Module getModule(String name) {
        return moduleMap.get(name);
    }
    
    @Override
    protected Collection<Module> getModules() {
        return moduleMap.values();
    }

    @Override
    public void collectRules(Collection<TransformationRule> rules) {
        for(Module module : moduleMap.values())
            module.getRules();
    }

}
