package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;

public class EPlaceholder extends DecoratingExpression {
    public EPlaceholder(long loc, Expression expression) {
        super(loc, expression);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return expression.simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return expression.resolve(context);
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return expression.resolveAsPattern(context);
    }
}
