package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class StringConstant extends Constant {
    String value;

    public StringConstant(String value) {
        super(Types.STRING);
        this.value = value;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(value);
    }
    
    @Override
    public String toString() {
        return "\"" + value + "\"";
    }
    
    public String getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        StringConstant other = (StringConstant) obj;
        return value.equals(other.value);
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.loadConstant(value);
        mb.push(parameter, Types.STRING);        
        mb.invokeVirtual(TypeDesc.STRING, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        mb.ifZeroComparisonBranch(failure, "==");
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return value;
    }
}
