package org.simantics.scl.compiler.completions.parsing;

import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.compilation.DeclarationClassification;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserImpl;
import org.simantics.scl.compiler.internal.parsing.parser.SCLParserOptions;

public class RobustModuleParser {
    
    private static List<DeclarationAst> parseSegment(CompilationContext context, AtomicBoolean firstToken, Reader reader) {
        SCLParserImpl parser = new SCLParserImpl(reader);
        parser.getLexer().isFirstToken = firstToken.get();
        parser.setCompilationContext(context);
        parser.setParserOptions(SCLParserOptions.MODULE_DEFAULT);
        List<DeclarationAst> result = (List<DeclarationAst>)parser.parseModule();
        firstToken.set(parser.getLexer().isFirstToken);
        return result;
    }

    public static DeclarationClassification parse(CompilationContext context, String sourceText) {
        DeclarationClassification declarations = new DeclarationClassification(context);
        AtomicBoolean firstToken = new AtomicBoolean(false);
        for(ModuleSegment segment : RobustModuleSplitter.split(sourceText)) {
            //System.out.println("----------------------------------------------------------");
            //System.out.println(sourceText.substring(segment.begin, segment.end));

            if(segment.hasErrors) {
                System.out.println("    has errors");
                // TODO we could try some special parsing here
            }
            else {
                Reader reader = new SubstringReader(sourceText, segment.begin, segment.end);
                try {
                    for(DeclarationAst declaration : parseSegment(context, firstToken, reader))
                        declarations.handle(declaration);
                } catch(Exception e) {
                    // This is normal
                    //e.printStackTrace(System.out);
                }
            }
        }
        return declarations;
    }
}
