/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.scenegraph.utils.VolatileImageProvider;

public class VolatileImageCache {
    private static final boolean DEBUG = false;
    private static VolatileImageCache instance = null;
    private static final int MAX_SIZE = 0x800000;
    private int size = 0;
    private int counter = 0;
    private static final String MSG = "[provider #%-10d @%-8x][image (%-3d,%-3d)][cache entries=%-4d, old size=%-10d, new size=%-10d, size change=%-+6d] %s";
    private final Map<VolatileImageProviderImpl, VolatileImageProviderImpl> cache = new LinkedHashMap<VolatileImageProviderImpl, VolatileImageProviderImpl>(50, 0.75f, true){
        private static final long serialVersionUID = 5946026822169837291L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<VolatileImageProviderImpl, VolatileImageProviderImpl> eldest) {
            boolean result;
            boolean bl = result = VolatileImageCache.this.size > 0x800000;
            if (result) {
                VolatileImageProviderImpl impl = eldest.getKey();
                VolatileImageCache.this.size -= impl.w * impl.h;
                VolatileImageCache.flushImageRef(impl.imageRef);
                impl.imageRef = null;
            }
            return result;
        }
    };

    private VolatileImageCache() {
    }

    public static VolatileImageCache getInstance() {
        if (instance == null) {
            instance = new VolatileImageCache();
        }
        return instance;
    }

    private static void debug(VolatileImageProviderImpl i, int entries, int oldSize, int newSize, String msg) {
    }

    private static final void flushImageRef(Reference<? extends Image> imageRef) {
        if (imageRef != null) {
            Image img = imageRef.get();
            imageRef.clear();
            if (img != null) {
                img.flush();
            }
        }
    }

    VolatileImageProvider create(int w, int h) {
        VolatileImageProviderImpl result = new VolatileImageProviderImpl(w, h);
        return result;
    }

    class VolatileImageProviderImpl
    implements VolatileImageProvider {
        private final int id;
        private final int w;
        private final int h;
        private Reference<VolatileImage> imageRef = null;

        public VolatileImageProviderImpl(int w, int h) {
            this.id = VolatileImageCache.this.counter++;
            this.w = w;
            this.h = h;
        }

        private VolatileImage dereferenceImage() {
            return this.imageRef != null ? this.imageRef.get() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VolatileImage get(GraphicsConfiguration gc, AtomicInteger _validateResult) {
            int validateResult = 2;
            VolatileImage vimg = this.dereferenceImage();
            if (vimg != null) {
                validateResult = vimg.validate(gc);
            }
            if (validateResult == 1) {
                // empty if block
            }
            if (validateResult == 2) {
                vimg = gc.createCompatibleVolatileImage(this.w, this.h, 3);
                if (vimg == null) {
                    throw new IllegalStateException(this + ": got null VolatileImage from GraphicsConfiguration " + gc);
                }
                this.imageRef = new SoftReference<VolatileImage>(vimg);
                Map<VolatileImageProviderImpl, VolatileImageProviderImpl> map = VolatileImageCache.this.cache;
                synchronized (map) {
                    VolatileImageProviderImpl oldObject = VolatileImageCache.this.cache.remove(this);
                    boolean wasCached = oldObject == this;
                    VolatileImageCache.this.cache.put(this, this);
                    if (!wasCached) {
                        VolatileImageCache.this.size += this.w * this.h;
                    }
                }
            }
            if (_validateResult != null) {
                _validateResult.set(validateResult);
            }
            return vimg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Map<VolatileImageProviderImpl, VolatileImageProviderImpl> map = VolatileImageCache.this.cache;
            synchronized (map) {
                int newSize = VolatileImageCache.this.size;
                VolatileImageProviderImpl removed = VolatileImageCache.this.cache.remove(this);
                if (removed == this) {
                    VolatileImageCache.this.size = newSize -= this.w * this.h;
                }
                if (this.imageRef != null) {
                    VolatileImageCache.flushImageRef(this.imageRef);
                    this.imageRef = null;
                }
            }
        }
    }
}

