/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.InitValueSupport;

public class ShapeNode2
extends G2DNode
implements InitValueSupport {
    private static final long serialVersionUID = -5700299566608619380L;
    protected static final Stroke DEFAULT_STROKE = new BasicStroke(2.0f);
    protected Shape shape = null;
    protected Stroke stroke = DEFAULT_STROKE;
    protected Paint strokeColor = Color.BLACK;
    protected Paint fillColor = null;
    protected boolean scaleStroke = false;
    protected boolean scaleShape = false;
    protected transient Shape dynamicShape = null;
    protected transient Stroke dynamicStroke = null;
    protected transient Paint dynamicStrokeColor = null;
    protected transient Paint dynamicFillColor = null;
    protected transient Boolean dynamicScaleStroke = null;
    protected transient Boolean dynamicScaleShape = null;

    @INode.PropertySetter(value="shape")
    @INode.SyncField(value={"shape"})
    public void setShape(Shape shape) {
        this.shape = shape;
        this.repaint();
    }

    @INode.PropertySetter(value="stroke")
    @INode.SyncField(value={"stroke"})
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @INode.PropertySetter(value="strokeColor")
    @INode.SyncField(value={"strokeColor"})
    public void setStrokeColor(Paint color) {
        this.strokeColor = color;
    }

    @INode.PropertySetter(value="fillColor")
    @INode.SyncField(value={"fillColor"})
    public void setFillColor(Paint color) {
        this.fillColor = color;
    }

    @INode.SyncField(value={"scaleStroke"})
    public void setScaleStroke(boolean scaleStroke) {
        this.scaleStroke = scaleStroke;
    }

    @INode.SyncField(value={"scaleShape"})
    public void setScaleShape(boolean scaleShape) {
        this.scaleShape = scaleShape;
    }

    @Override
    public void render(Graphics2D g2d) {
        Shape shape;
        Shape shape2 = shape = this.dynamicShape != null ? this.dynamicShape : this.shape;
        if (shape == null) {
            return;
        }
        AffineTransform ot = this.setupRender(g2d);
        this.renderShape(g2d, shape);
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    protected AffineTransform setupRender(Graphics2D g2d) {
        boolean scaleShape;
        AffineTransform old = null;
        if (!this.transform.isIdentity()) {
            old = g2d.getTransform();
            g2d.transform(this.transform);
        }
        boolean bl = scaleShape = Boolean.TRUE.equals(this.dynamicScaleShape) ? true : this.scaleShape;
        if (scaleShape) {
            double xs = g2d.getTransform().getScaleX();
            double ys = g2d.getTransform().getScaleY();
            g2d.scale(1.0 / xs, 1.0 / ys);
        }
        return old;
    }

    protected void renderShape(Graphics2D g2d, Shape s) {
        Stroke stroke;
        Paint color;
        Paint paint = color = this.dynamicFillColor != null ? this.dynamicFillColor : this.fillColor;
        if (color != null) {
            g2d.setPaint(color);
            g2d.fill(s);
        }
        Stroke stroke2 = stroke = this.dynamicStroke != null ? this.dynamicStroke : this.stroke;
        if (stroke != null) {
            boolean scaleStroke;
            Paint paint2 = color = this.dynamicStrokeColor != null ? this.dynamicStrokeColor : this.strokeColor;
            if (color != null) {
                g2d.setPaint(color);
            }
            boolean bl = scaleStroke = Boolean.TRUE.equals(this.dynamicScaleStroke) ? true : this.scaleStroke;
            if (scaleStroke && stroke instanceof BasicStroke) {
                BasicStroke bs = GeometryUtils.scaleStroke(stroke, (float)(1.0 / GeometryUtils.getScale(g2d.getTransform())));
                g2d.setStroke(bs);
            } else {
                g2d.setStroke(stroke);
            }
            g2d.draw(s);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.shape == null) {
            return null;
        }
        return this.shape.getBounds2D();
    }

    public void setValue(String key, Object value) {
        if ("shape".equals(key)) {
            this.dynamicShape = (Shape)value;
        } else if ("stroke".equals(key)) {
            this.dynamicStroke = (Stroke)value;
        } else if ("strokeColor".equals(key)) {
            this.dynamicStrokeColor = (Paint)value;
        } else if ("fillColor".equals(key)) {
            this.dynamicFillColor = (Paint)value;
        } else if ("scaleStroke".equals(key)) {
            this.dynamicScaleStroke = (Boolean)value;
        } else if ("scaleShape".equals(key)) {
            this.dynamicScaleShape = (Boolean)value;
        }
    }

    @Override
    public void initValues() {
        this.dynamicShape = null;
        this.dynamicStroke = null;
        this.dynamicStrokeColor = null;
        this.dynamicFillColor = null;
        this.dynamicScaleStroke = null;
        this.dynamicScaleShape = null;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [shape=" + this.shape + ",color=" + this.strokeColor + ",fill=" + this.fillColor + "]";
    }
}

