/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.scenegraph.NodeException;
import org.simantics.scenegraph.utils.BufferedImage;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ScenegraphUtils {
    protected static final void dispatch(IThreadWorkQueue queue, final Runnable runnable) {
        if (queue == null) {
            runnable.run();
        } else if (queue.currentThreadAccess()) {
            runnable.run();
        } else {
            ThreadUtils.asyncExec((IThreadWorkQueue)queue, (Runnable)new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            });
        }
    }

    private static Class<?> getPropertyType(Method method) {
        return (Class)method.getGenericParameterTypes()[0];
    }

    private static Binding getPropertyBinding(Method method) {
        try {
            return Bindings.getBindingUnchecked(ScenegraphUtils.getPropertyType(method));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Binding getGenericPropertyBinding(Method method) {
        try {
            Binding specific = ScenegraphUtils.getPropertyBinding(method);
            return Bindings.getBinding((Datatype)specific.type());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getSynchronizeMethod(Object node, String propertyName) {
        try {
            String methodName = "synchronize" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method[] methodArray = node.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Function1<Object, Boolean> getMethodPropertyFunction(final IThreadWorkQueue queue, final Object node, String propertyName) {
        final Method synchronizeMethod = ScenegraphUtils.getSynchronizeMethod(node, propertyName);
        if (synchronizeMethod == null) {
            throw new NodeException("Did not find synchronize method for property '" + propertyName + "'");
        }
        final Class<?> type = ScenegraphUtils.getPropertyType(synchronizeMethod);
        final Binding binding = ScenegraphUtils.getPropertyBinding(synchronizeMethod);
        final Binding genericBinding = ScenegraphUtils.getGenericPropertyBinding(synchronizeMethod);
        return new FunctionImpl1<Object, Boolean>(){

            public Boolean apply(final Object value) {
                ScenegraphUtils.dispatch(queue, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (type.isPrimitive()) {
                                synchronizeMethod.invoke(node, value);
                            } else if (value == null) {
                                synchronizeMethod.invoke(node, value);
                            } else if (type.isInstance(value)) {
                                synchronizeMethod.invoke(node, value);
                            } else if (type.isArray()) {
                                synchronizeMethod.invoke(node, value);
                            } else {
                                Object instance = binding.createDefaultUnchecked();
                                binding.readFrom(genericBinding, value, instance);
                                synchronizeMethod.invoke(node, instance);
                            }
                        }
                        catch (IllegalArgumentException e1) {
                            e1.printStackTrace();
                        }
                        catch (IllegalAccessException e1) {
                            e1.printStackTrace();
                        }
                        catch (BindingException e) {
                            e.printStackTrace();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                });
                return false;
            }
        };
    }

    public static SVGDiagram loadSVGDiagram(SVGUniverse univ, String text) throws SVGException {
        SVGDiagram diagram = univ.getDiagram(univ.loadSVG((Reader)new StringReader(text), UUID.randomUUID().toString()), false);
        diagram.setIgnoringClipHeuristic(true);
        return diagram;
    }

    public static java.awt.image.BufferedImage loadSVG(SVGUniverse univ, String text, double scale) throws SVGException {
        SVGDiagram diagram = ScenegraphUtils.loadSVGDiagram(univ, text);
        return ScenegraphUtils.paintSVG(diagram, scale);
    }

    public static java.awt.image.BufferedImage paintSVG(SVGDiagram diagram, double scale) throws SVGException {
        BufferedImage bi = new BufferedImage(diagram);
        bi.paintToBuffer(AffineTransform.getScaleInstance(scale, scale), null, 0.0f);
        return bi.getBuffer();
    }

    public static java.awt.image.BufferedImage paintSVG(SVGDiagram diagram, AffineTransform transform, float margin) throws SVGException {
        BufferedImage bi = new BufferedImage(diagram);
        bi.paintToBuffer(transform, null, margin);
        return bi.getBuffer();
    }

    public static synchronized java.awt.image.BufferedImage loadSVG(SVGUniverse univ, String text, int maxDimension) throws SVGException {
        SVGDiagram diagram = univ.getDiagram(univ.loadSVG((Reader)new StringReader(text), UUID.randomUUID().toString()), false);
        diagram.setIgnoringClipHeuristic(true);
        BufferedImage bi = new BufferedImage(diagram);
        Rectangle2D bounds = diagram.getViewRect();
        double xScale = (double)maxDimension / bounds.getWidth();
        double yScale = (double)maxDimension / bounds.getHeight();
        double scale = Math.min(xScale, yScale);
        bi.paintToBuffer(AffineTransform.getScaleInstance(scale, scale), null, 0.0f);
        return bi.getBuffer();
    }

    private static Variant extractVariant(Object value) {
        if (value instanceof Variant) {
            return (Variant)value;
        }
        return Variant.ofInstance((Object)value);
    }

    public static Map<String, Variant> parameters(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        HashMap<String, Variant> result = new HashMap<String, Variant>();
        int i = 0;
        while (i < keyValuePairs.length) {
            String key = (String)keyValuePairs[i];
            Variant value = ScenegraphUtils.extractVariant(keyValuePairs[i + 1]);
            result.put(key, value);
            i += 2;
        }
        return result;
    }
}

