/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.DummyComponent;

@ExportableWidget.OutputWidget(value={"value"})
@ExportableWidget.InputWidget(value={"value"})
public class MonitorNode
extends ComponentNode<JTextField>
implements ActionListener,
FocusListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 7073028693751719102L;
    protected boolean editable = true;
    protected String value = "";
    protected String tooltip = "";
    protected double borderWidth = 0.0;
    protected transient ActionListener actionListener = null;
    private boolean doResize = false;
    protected Font font = null;
    protected Color color = null;
    protected int halign = 2;

    public String toString() {
        return String.valueOf(super.toString()) + "[editable=" + this.editable + ", value=" + this.value + "]";
    }

    private void markResize() {
        this.doResize = true;
    }

    @Override
    public void init() {
        this.component = new TextField(this.borderWidth, this);
        ((JTextField)this.component).setEditable(this.editable);
        ((JTextField)this.component).setEnabled(this.editable);
        ((JTextField)this.component).addActionListener(this);
        ((JTextField)this.component).addFocusListener(this);
        ((JTextField)this.component).addKeyListener(this);
        super.init();
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean value) {
        this.editable = value;
        if (this.component != null) {
            ((JTextField)this.component).setEditable(value);
            ((JTextField)this.component).setEnabled(value);
        }
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"borderWidth"})
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth.floatValue();
        if (this.component != null) {
            ((TextField)this.component).setBorder(borderWidth.floatValue());
        }
    }

    @INode.SyncField(value={"value"})
    public void setText(String value) {
        this.value = value;
        if (this.component != null) {
            ((JTextField)this.component).setText(value);
            this.markResize();
            ((JTextField)this.component).repaint();
        }
    }

    @INode.SyncField(value={"tooltip"})
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        if (this.component != null) {
            ((JTextField)this.component).setToolTipText(tooltip);
        }
    }

    @INode.PropertySetter(value="Font")
    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
            this.markResize();
        }
    }

    @INode.PropertySetter(value="Color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((JTextField)this.component).setForeground(color);
            this.markResize();
        }
    }

    @INode.SyncField(value={"halign"})
    public void setHorizontalAlign(int halign) {
        this.halign = halign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g2d) {
        if (this.doResize) {
            this.recalculateSize(g2d);
        }
        this.doResize = false;
        if (this.component != null) {
            JTextField jTextField = (JTextField)this.component;
            synchronized (jTextField) {
                if (((JTextField)this.component).getHorizontalAlignment() != this.halign) {
                    ((JTextField)this.component).setHorizontalAlignment(this.halign);
                }
                super.render(g2d);
            }
        }
    }

    private void recalculateSize(Graphics2D g2d) {
        if (this.component == null || this.value == null) {
            return;
        }
        Font font = this.getComponentFont();
        if (font != null) {
            String measuredValue = this.value;
            if (this.bounds == null) {
                FontMetrics metrics = ((JTextField)this.component).getFontMetrics(font);
                Rectangle2D size = metrics.getStringBounds(measuredValue, g2d);
                int xPadding = 15;
                int yPadding = 2;
                this.setBounds(new Rectangle2D.Double(0.0, 0.0, xPadding + (int)Math.ceil(size.getWidth()), yPadding + (int)Math.ceil(size.getHeight())));
            } else {
                float min = 6.0f;
                float max = 62.0f;
                while (max < 200.0f) {
                    FontMetrics metrics = ((JTextField)this.component).getFontMetrics(font = font.deriveFont(max));
                    Rectangle2D fbounds = metrics.getStringBounds(measuredValue, g2d);
                    if (!this.fits(this.bounds, fbounds)) break;
                    max += 20.0f;
                }
                if (max < 200.0f) {
                    while (true) {
                        float half = (max + min) / 2.0f;
                        float interval = max - min;
                        FontMetrics metrics = ((JTextField)this.component).getFontMetrics(font = font.deriveFont(half));
                        Rectangle2D fbounds = metrics.getStringBounds(measuredValue, g2d);
                        if (this.fits(this.bounds, fbounds)) {
                            if (interval <= 1.0f) break;
                            min = half;
                            continue;
                        }
                        if (interval <= 1.0f) {
                            font = font.deriveFont(min);
                            break;
                        }
                        max = half;
                    }
                }
                this.setComponentFont(font);
            }
        }
    }

    private boolean fits(Rectangle2D parent, Rectangle2D child) {
        return parent.getWidth() >= child.getWidth() && parent.getHeight() >= child.getHeight();
    }

    public String getText() {
        return this.value;
    }

    public Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName()) && this.component != null) {
            JTextField jTextField = (JTextField)this.component;
            synchronized (jTextField) {
                ((JTextField)this.component).setText((String)evt.getNewValue());
                this.markResize();
                ((JTextField)this.component).repaint();
            }
        }
        if ("editable".equals(evt.getPropertyName()) && this.component != null) {
            JTextField jTextField = (JTextField)this.component;
            synchronized (jTextField) {
                ((JTextField)this.component).setEditable((Boolean)evt.getNewValue());
                ((JTextField)this.component).setEnabled((Boolean)evt.getNewValue());
            }
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loseFocus();
    }

    void loseFocus() {
        if (this.component != null && ((JTextField)this.component).isFocusOwner() && this.container.getParent() != null) {
            this.container.getParent().requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        if (this.component != null) {
            ((JTextField)this.component).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.component != null) {
            ActionEvent e = new ActionEvent(this.component, 1001, ((JTextField)this.component).getText());
            this.performAction(e);
        }
    }

    @INode.ServerSide
    public void performAction(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getModifiers() == 0 && e.getKeyCode() == 27) {
            this.loseFocus();
        }
    }

    public String widgetGet(String name) {
        if ("value".equals(name)) {
            return this.value;
        }
        return null;
    }

    public void widgetSet(String name, String value) {
        if ("value".equals(name)) {
            ActionEvent e = new ActionEvent(new DummyComponent(), 1001, value);
            this.performAction(e);
        }
    }

    static class TextField
    extends JTextField {
        private static final int X_INSET = 5;
        private static final int Y_INSET = -1;
        private static final long serialVersionUID = -668522226693100386L;
        private Border lineBorder;
        private final MonitorNode node;

        public TextField(double borderWidth, MonitorNode node) {
            this.lineBorder = borderWidth < 0.1 ? new EmptyBorder(-1, 5, -1, 5) : new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(-1, 5, -1, 5));
            this.node = node;
            this.setHorizontalAlignment(0);
            this.setAlignmentY(0.5f);
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(this.lineBorder);
        }

        public void setBorder(double borderWidth) {
            this.lineBorder = borderWidth < 0.1 ? new EmptyBorder(-1, 5, -1, 5) : new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(-1, 5, -1, 5));
            super.setBorder(this.lineBorder);
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            Point2D p2d = this.node.localToControl(event.getPoint());
            Point p = new Point((int)p2d.getX(), -20 + (int)p2d.getY());
            return p;
        }
    }
}

