/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;

public class CheckBoxNode
extends ComponentNode<JCheckBox>
implements ActionListener {
    private static final long serialVersionUID = 3161843367263793336L;
    protected String text;
    protected Font font = null;
    protected Color color = null;
    protected transient Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    @Override
    public void render(Graphics2D g2d) {
        if (this.component != null && ((JCheckBox)this.component).getText() != null && !((JCheckBox)this.component).getText().equals(this.text)) {
            ((JCheckBox)this.component).setText(this.text);
        }
        super.render(g2d);
    }

    @INode.SyncField(value={"text"})
    public void setText(String text) {
        this.text = text;
    }

    @INode.PropertySetter(value="Font")
    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
        }
    }

    @INode.PropertySetter(value="Color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((JCheckBox)this.component).setForeground(color);
        }
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    @INode.ServerSide
    public void actionPerformed(ActionEvent e) {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    @Override
    public void init() {
        this.component = new JCheckBox();
        ((JCheckBox)this.component).addActionListener(this);
        super.init();
    }
}

