/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management.install;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.osgi.framework.BundleContext;
import org.simantics.project.internal.Activator;

public class InstallDescriptionParser {
    private static final String PROP_AGENT_LOCATION = "eclipse.p2.agentLocation";
    private static final String PROP_ARTIFACT_REPOSITORY = "eclipse.p2.artifacts";
    private static final String PROP_BUNDLE_LOCATION = "eclipse.p2.bundleLocation";
    private static final String PROP_INSTALL_LOCATION = "eclipse.p2.installLocation";
    private static final String PROP_IS_AUTO_START = "eclipse.p2.autoStart";
    private static final String PROP_LAUNCHER_NAME = "eclipse.p2.launcherName";
    private static final String PROP_METADATA_REPOSITORY = "eclipse.p2.metadata";
    private static final String PROP_PROFILE_NAME = "eclipse.p2.profileName";
    private static final String PROP_ROOT_ID = "eclipse.p2.rootId";
    private static final String PROP_ROOT_VERSION = "eclipse.p2.rootVersion";
    private static final String PROP_ROOTS = "eclipse.p2.roots";

    public static InstallDescription createDescription(String site, SubMonitor monitor) throws Exception {
        Map properties;
        if (site == null) {
            site = "installer.properties";
        }
        URI propsURI = URIUtil.fromString((String)site);
        InputStream in = null;
        if (!propsURI.isAbsolute()) {
            String installerInstallArea = System.getProperty("osgi.install.area");
            if (installerInstallArea == null) {
                throw new IllegalStateException("Install area is not specified.");
            }
            propsURI = URIUtil.append((URI)URIUtil.fromString((String)installerInstallArea), (String)site);
            File installerDescription = URIUtil.toFile((URI)propsURI);
            if (!installerDescription.exists()) {
                throw new IllegalStateException("Can't find install description file: " + installerDescription);
            }
        }
        try {
            in = InstallDescriptionParser.getTransport().stream(propsURI, (IProgressMonitor)monitor);
            properties = CollectionUtils.loadProperties((InputStream)in);
        }
        catch (Throwable installerDescription) {
            InstallDescriptionParser.safeClose(in);
            throw installerDescription;
        }
        InstallDescriptionParser.safeClose(in);
        URI base = InstallDescriptionParser.getBase(propsURI);
        InstallDescription result = new InstallDescription();
        result = InstallDescriptionParser.initialize(result, properties, base);
        InstallDescriptionParser.initializeProfileProperties(result, properties);
        result = InstallDescriptionParser.initialize(result, CollectionUtils.toMap((Properties)System.getProperties()), base);
        return result;
    }

    private static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getDefault().getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }

    private static Transport getTransport() {
        return (Transport)InstallDescriptionParser.getAgent().getService(Transport.SERVICE_NAME);
    }

    private static URI getBase(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        int slashIndex = uriString.lastIndexOf(47);
        if (slashIndex == -1 || slashIndex == uriString.length() - 1) {
            return uri;
        }
        return URI.create(uriString.substring(0, slashIndex + 1));
    }

    private static InstallDescription initialize(InstallDescription description, Map<String, String> properties, URI base) {
        String rootSpec;
        String id;
        String property = properties.get(PROP_ARTIFACT_REPOSITORY);
        if (property != null) {
            description.setArtifactRepositories(InstallDescriptionParser.getURIs(property, base));
        }
        if ((property = properties.get(PROP_METADATA_REPOSITORY)) != null) {
            description.setMetadataRepositories(InstallDescriptionParser.getURIs(property, base));
        }
        if ((property = properties.get(PROP_IS_AUTO_START)) != null) {
            description.setAutoStart(Boolean.TRUE.toString().equalsIgnoreCase(property));
        }
        if ((property = properties.get(PROP_LAUNCHER_NAME)) != null) {
            description.setLauncherName(property);
        }
        if ((property = properties.get(PROP_INSTALL_LOCATION)) != null) {
            description.setInstallLocation((IPath)new Path(property));
        }
        if ((property = properties.get(PROP_AGENT_LOCATION)) != null) {
            description.setAgentLocation((IPath)new Path(property));
        }
        if ((property = properties.get(PROP_BUNDLE_LOCATION)) != null) {
            description.setBundleLocation((IPath)new Path(property));
        }
        if ((property = properties.get(PROP_PROFILE_NAME)) != null) {
            description.setProductName(property);
        }
        if ((id = properties.get(PROP_ROOT_ID)) != null) {
            String version = properties.get(PROP_ROOT_VERSION);
            try {
                description.setRoots(new IVersionedId[]{new VersionedId(id, version)});
            }
            catch (IllegalArgumentException e) {
                LogHelper.log((IStatus)new Status(4, "org.simantics.project", "Invalid version in install description: " + version, (Throwable)e));
            }
        }
        if ((rootSpec = properties.get(PROP_ROOTS)) != null) {
            String[] rootList = InstallDescriptionParser.getArrayFromString(rootSpec, ",");
            ArrayList<IVersionedId> roots = new ArrayList<IVersionedId>(rootList.length);
            int i = 0;
            while (i < rootList.length) {
                try {
                    roots.add(VersionedId.parse((String)rootList[i]));
                }
                catch (IllegalArgumentException e) {
                    LogHelper.log((IStatus)new Status(4, "org.simantics.project", "Invalid version in install description: " + rootList[i], (Throwable)e));
                }
                ++i;
            }
            if (!roots.isEmpty()) {
                description.setRoots(roots.toArray(new IVersionedId[roots.size()]));
            }
        }
        return description;
    }

    private static void initializeProfileProperties(InstallDescription description, Map<String, String> properties) {
        HashMap<String, String> profileProperties = new HashMap<String, String>(properties);
        profileProperties.remove(PROP_PROFILE_NAME);
        profileProperties.remove(PROP_ARTIFACT_REPOSITORY);
        profileProperties.remove(PROP_METADATA_REPOSITORY);
        profileProperties.remove(PROP_IS_AUTO_START);
        profileProperties.remove(PROP_LAUNCHER_NAME);
        profileProperties.remove(PROP_AGENT_LOCATION);
        profileProperties.remove(PROP_BUNDLE_LOCATION);
        profileProperties.remove(PROP_ROOT_ID);
        profileProperties.remove(PROP_ROOT_VERSION);
        profileProperties.remove(PROP_ROOTS);
        description.setProfileProperties(profileProperties);
    }

    private static URI[] getURIs(String spec, URI base) {
        String[] urlSpecs = InstallDescriptionParser.getArrayFromString(spec, ",");
        ArrayList<URI> result = new ArrayList<URI>(urlSpecs.length);
        int i = 0;
        while (i < urlSpecs.length) {
            try {
                URI uri = URIUtil.fromString((String)urlSpecs[i]);
                uri = URIUtil.makeAbsolute((URI)uri, (URI)base);
                result.add(uri);
            }
            catch (URISyntaxException e) {
                LogHelper.log((IStatus)new Status(4, "org.simantics.project", "Invalid URL in install description: " + urlSpecs[i], (Throwable)e));
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new URI[result.size()]);
    }

    private static void safeClose(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }
}

