/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.db.Driver;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.ServerEx;
import org.simantics.db.ServerI;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.XSupport;
import org.simantics.graph.db.CoreInitialization;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.DatabaseManagementResource;
import org.simantics.layer0.Layer0;
import org.simantics.project.SessionDescriptor;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.project.management.PlatformUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManager.class);
    public static final Properties DEFAULT = new Properties();
    final Driver driver;
    Map<File, ServerHost> servers = Collections.synchronizedMap(new HashMap());

    static {
        DEFAULT.setProperty("user", "Default User");
        DEFAULT.setProperty("password", "");
    }

    public ServerManager(Driver driver) throws IOException {
        this.driver = driver;
    }

    public Driver.Management getManagement(File dbFolder) throws DatabaseException {
        return this.driver.getManagement(dbFolder.getAbsolutePath(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SessionDescriptor createDatabase(File databaseDirectory) throws DatabaseException {
        try {
            LOGGER.debug("Creating database to " + databaseDirectory);
            Session session = null;
            ServerEx server1 = this.getServer(databaseDirectory);
            server1.start();
            try {
                Properties info = new Properties();
                info.setProperty("user", "Default User");
                info.setProperty("password", "");
                session = server1.createSession(info);
                XSupport xs = (XSupport)session.getService(XSupport.class);
                ClusterUID[] clusters = xs.listClusters();
                if (clusters.length > 1) {
                    ReadRequest req = new ReadRequest(){

                        public void run(ReadGraph g) {
                            Layer0.getInstance((ReadGraph)g);
                        }
                    };
                    session.syncRequest((Read)req);
                    SessionDescriptor sessionDescriptor2 = new SessionDescriptor(session, false);
                    return sessionDescriptor2;
                }
                CoreInitialization.initializeBuiltins((Session)session);
                ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                GraphBundle l0 = PlatformUtil.getGraph("org.simantics.layer0");
                final GraphBundleEx l0ex = GraphBundleEx.extend(l0);
                l0ex.build();
                long[] resourceArray = CoreInitialization.initializeGraph((Session)session, (TransferableGraph1)l0ex.getGraph());
                l0ex.setResourceArray(resourceArray);
                ((XSupport)session.getService(XSupport.class)).setServiceMode(true, true);
                DatabaseManagementResource.getInstance((RequestProcessor)session);
                Layer0.getInstance((RequestProcessor)session);
                session.syncRequest((WriteOnly)new WriteOnlyRequest(){

                    public void perform(WriteOnlyGraph graph) throws DatabaseException {
                        graph.newClusterSet(graph.getRootLibrary());
                        DatabaseManagement mgt = new DatabaseManagement();
                        mgt.createGraphBundle(graph, l0ex);
                        graph.flushCluster();
                    }
                });
                SessionDescriptor sessionDescriptor = new SessionDescriptor(session, true);
                return sessionDescriptor;
            }
            finally {
                if (session == null) {
                    server1.stop();
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException("Failed to create Simantics database.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerEx getServer(File databaseDirectory) throws DatabaseException {
        File file = databaseDirectory.getAbsoluteFile();
        ServerHost host = null;
        Map<File, ServerHost> map = this.servers;
        synchronized (map) {
            host = this.servers.get(file);
            if (host == null) {
                ServerI server = this.driver.getServer(file.getAbsolutePath(), null);
                try {
                    host = new ServerHost(server, databaseDirectory);
                }
                catch (IOException e) {
                    throw new DatabaseException("Failed to load " + databaseDirectory, (Throwable)e);
                }
                this.servers.put(file, host);
            }
        }
        ProxyServer proxy = new ProxyServer(host);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<File, ServerHost> map = this.servers;
        synchronized (map) {
            for (ServerHost host : this.servers.values()) {
                ServerI server = host.actual;
                try {
                    if (!server.isActive()) continue;
                    server.stop();
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to stop database server.", (Throwable)e);
                }
            }
            this.servers.clear();
        }
    }

    public static int getFreeEphemeralPort() {
        while (true) {
            int n;
            block8: {
                Socket s = null;
                try {
                    s = new Socket();
                    s.bind(null);
                    n = s.getLocalPort();
                    if (s == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            s.close();
                        }
                        throw throwable;
                    }
                    catch (BindException bindException) {
                        continue;
                    }
                    catch (Throwable e) {
                        throw new Error(e);
                    }
                }
                s.close();
            }
            return n;
            break;
        }
    }

    public static void createServerConfig(File file) throws IOException {
        InputStream is = ServerManager.class.getResourceAsStream("server_template.cnfg");
        byte[] data = StreamUtil.readFully((InputStream)is);
        is.close();
        FileOutputStream os = new FileOutputStream(file, false);
        os.write(data);
        Properties properties = new Properties();
        properties.store(os, "# automatically generated properties");
        os.close();
    }

    public class ProxyServer
    implements ServerEx {
        boolean running;
        ServerHost actual;

        public ProxyServer(ServerHost actual) {
            this.actual = actual;
        }

        public File getDatabase() {
            return this.actual.getDatabase();
        }

        public Properties getProperties() {
            return this.actual.getProperties();
        }

        public String getAddress() throws DatabaseException {
            return this.actual.getAddress();
        }

        public boolean isActive() {
            return this.running && this.actual.isActive();
        }

        public void start() throws DatabaseException {
            if (this.running) {
                return;
            }
            this.actual.start();
            this.running = true;
        }

        public void stop() throws DatabaseException {
            if (!this.running) {
                return;
            }
            this.actual.stop();
            this.running = false;
        }

        public Session createSession(Properties properties) throws DatabaseException {
            return ServerManager.this.driver.getSession(this.actual.getAddress(), properties);
        }

        public ServiceLocator getServiceLocator(Properties info) throws DatabaseException {
            return this.createSession(info);
        }

        public String execute(String command) throws DatabaseException {
            return this.actual.execute(command);
        }

        public String executeAndDisconnect(String command) throws DatabaseException {
            return this.actual.executeAndDisconnect(command);
        }
    }

    class ServerHost
    implements ServerEx {
        File database;
        ServerI actual;
        int refCount = 0;
        Properties properties;

        public ServerHost(ServerI actual, File database) throws IOException {
            this.actual = actual;
            this.database = database;
            this.properties = new Properties();
        }

        public File getDatabase() {
            return this.database;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getAddress() throws DatabaseException {
            return this.actual.getAddress();
        }

        public boolean isActive() {
            try {
                return this.actual.isActive();
            }
            catch (DatabaseException databaseException) {
                return false;
            }
        }

        public void start() throws DatabaseException {
            boolean isRunning = this.actual.isActive();
            if (!isRunning) {
                this.actual.start();
            }
            ++this.refCount;
        }

        public void stop() throws DatabaseException {
            if (this.refCount <= 0) {
                throw new DatabaseException("Trying to stop a standing process.");
            }
            --this.refCount;
            if (this.refCount > 1) {
                return;
            }
            this.actual.stop();
        }

        public Session createSession(Properties properties) throws DatabaseException {
            return ServerManager.this.driver.getSession(this.actual.getAddress(), properties);
        }

        public ServiceLocator getServiceLocator(Properties info) throws DatabaseException {
            return this.createSession(info);
        }

        public String execute(String command) throws DatabaseException {
            return this.actual.execute(command);
        }

        public String executeAndDisconnect(String command) throws DatabaseException {
            return this.actual.executeAndDisconnect(command);
        }
    }
}

