/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.internal;

import java.util.Hashtable;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.simantics.project.features.registry.IProjectFeatureRegistry;

/**
 * @author Tuukka Lehtonen
 */
public class Activator extends Plugin {

    // The plug-in ID
    public static final String     PLUGIN_ID                     = "org.simantics.project";

    // The shared instance
    private static Activator       plugin;

    private BundleContext          bundleContext;

    private ProjectFeatureRegistry projectFeatureRegistryService = null;
    @SuppressWarnings("rawtypes")
    private ServiceRegistration    projectFeatureRegistry        = null;

    /**
     * The constructor
     */
    public Activator() {
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        plugin = this;

        projectFeatureRegistryService = new ProjectFeatureRegistry();
        projectFeatureRegistry = bundleContext.registerService(IProjectFeatureRegistry.class.getName(), projectFeatureRegistryService, new Hashtable());
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        if (projectFeatureRegistry != null) {
            projectFeatureRegistry.unregister();
            projectFeatureRegistry = null;
        }

        this.bundleContext = null;
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    /**
     * @return
     */
    public IProjectFeatureRegistry getProjectFeatureRegistry() {
        return projectFeatureRegistryService;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

}
