/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.features;

import java.util.EnumSet;

/**
 * Describes the possible types of compatibility that can occur between two
 * project features.
 * 
 * @author Tuukka Lehtonen
 */
public enum Compatibility {
    COMPATIBLE,
    UNKNOWN,
    INCOMPATIBLE;
    
    public static final EnumSet<Compatibility> MAYBE_COMPATIBLE   = EnumSet.of(Compatibility.COMPATIBLE,
                                                                          Compatibility.UNKNOWN);

    public static final EnumSet<Compatibility> MAYBE_INCOMPATIBLE = EnumSet.of(Compatibility.UNKNOWN,
                                                                          Compatibility.INCOMPATIBLE);
}
