/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.schema;

import gnu.trove.map.hash.THashMap;
import java.util.Stack;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.schema.AdaptedLinkType;
import org.simantics.objmap.structural.schema.SimpleLinkType;

public class DefaultSchema
implements IMappingSchema<StructuralResource, IStructuralObject> {
    THashMap<Resource, ILinkType<StructuralResource, IStructuralObject>> domainLinkTypes = new THashMap();
    THashMap<Class<?>, ILinkType<StructuralResource, IStructuralObject>> rangeLinkTypes = new THashMap();

    public void addLinkType(SimpleLinkType linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, (Object)linkType);
        this.rangeLinkTypes.put(linkType.rangeType, (Object)linkType);
    }

    public void addLinkType(AdaptedLinkType linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, (Object)linkType);
        this.rangeLinkTypes.put(linkType.rangeType, (Object)linkType);
    }

    @Override
    public ILinkType<StructuralResource, IStructuralObject> linkTypeOfDomainElement(ReadGraph g, StructuralResource element) throws MappingException {
        try {
            for (Resource type : g.getTypes(element.getResource())) {
                ILinkType linkType = (ILinkType)this.domainLinkTypes.get((Object)type);
                if (linkType == null) continue;
                return linkType;
            }
            throw new MappingException("Didn't find a link type for " + NameUtils.getSafeName((ReadGraph)g, (Resource)element.getResource()) + ".");
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public ILinkType<StructuralResource, IStructuralObject> linkTypeOfRangeElement(IStructuralObject element) throws MappingException {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(element.getClass());
        if (type == null) {
            Class clazz;
            Stack clazzes = new Stack();
            Class<?>[] classArray = element.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                clazz = classArray[n2];
                clazzes.add(clazz);
                ++n2;
            }
            clazzes.add(element.getClass().getSuperclass());
            while (!clazzes.isEmpty()) {
                clazz = (Class)clazzes.pop();
                type = (ILinkType)this.rangeLinkTypes.get((Object)clazz);
                if (type != null) {
                    return type;
                }
                Class<?>[] classArray2 = clazz.getInterfaces();
                int n3 = classArray2.length;
                n = 0;
                while (n < n3) {
                    Class<?> c = classArray2[n];
                    clazzes.add(c);
                    ++n;
                }
            }
            throw new MappingException("Didn't find a link type for " + element + ".");
        }
        return type;
    }

    public ILinkType<StructuralResource, IStructuralObject> linkTypeOfDomainType(ReadGraph g, Resource type) {
        return (ILinkType)this.domainLinkTypes.get((Object)type);
    }

    public ILinkType<StructuralResource, IStructuralObject> linkTypeOfRangeType(Class<?> clazz) {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(clazz);
        if (type == null) {
            Class c;
            Stack clazzes = new Stack();
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = classArray[n2];
                clazzes.add(c);
                ++n2;
            }
            clazzes.add(clazz.getSuperclass());
            while (!clazzes.isEmpty()) {
                c = (Class)clazzes.pop();
                type = (ILinkType)this.rangeLinkTypes.get((Object)c);
                if (type != null) {
                    return type;
                }
                Class<?>[] classArray2 = c.getInterfaces();
                int n3 = classArray2.length;
                n = 0;
                while (n < n3) {
                    Class<?> c2 = classArray2[n];
                    clazzes.add(c2);
                    ++n;
                }
            }
        }
        return null;
    }
}

