/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.rules.domain;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.structural.stubs.StructuralResource2;

public class StructuralUtils {

	
	public static boolean isStructuralInstance(ReadGraph g, Resource r) throws DatabaseException {
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		 if (g.isInstanceOf(r, sr.Component)) {
			 Resource type = g.getSingleType(r);
			 return g.isInstanceOf(type, sr.Component);
		 }
		 return false;
		
	}
	
	public static Resource getContainingInstance(StructuralResource element) {
		if (!element.isStructural())
			return null;
		Resource instance = element.getContext().get(element.getContext().size()-1);
		return instance;
	}
	
	public static Resource getPublishedRelation(ReadGraph g, StructuralResource element, Resource relation) throws DatabaseException{
		Resource instance = getContainingInstance(element);
		if (instance == null)
			return null;
		
		Layer0 l0 = Layer0.getInstance(g);
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		
	    Resource type = null;
	    try {
	    	type = g.getSingleType(instance);
	    } catch (NoSingleResultException e) {
	    	
	    }
	    if (type == null)
	    	return null;
	    
	    boolean elementPublished = false;
	    Resource publicRelation = null;
	    for (Resource r : g.getObjects(type, l0.DomainOf)) {
	    	if (r.equals(element.getResource()))
	    		elementPublished = true;
	    	if (g.isInstanceOf(r, relation)) {
	    		if (element.getResource().equals(g.getPossibleObject(r, sr.IsBoundBy)))
	    			publicRelation = r;
	    	}
	    }
	    if (!elementPublished)
	    	return null;
	    return publicRelation;
	}
	
	public static Resource getOrCreatePublishedRelation(WriteGraph g, StructuralResource element, Resource relation) throws DatabaseException{
		Resource instance = getContainingInstance(element);
		if (instance == null)
			return null;
		
		Layer0 l0 = Layer0.getInstance(g);
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		
	    Resource type = g.getSingleType(instance);
	    
	    boolean elementPublished = false;
	    Resource publicRelation = null;
	    for (Resource r : g.getObjects(type, l0.DomainOf)) {
	    	if (r.equals(element.getResource()))
	    		elementPublished = true;
	    	if (g.isInstanceOf(r, relation)) {
	    		if (element.getResource().equals(g.getPossibleObject(r, sr.IsBoundBy)))
	    			publicRelation = r;
	    	}
	    }
	    if (!elementPublished)
	    	return null;
	    if (publicRelation != null)
	    	return publicRelation;
	    
	    publicRelation = g.newResource();
	    // TODO: type ConsistsOf publicRelation, publicRelation ConsistsOf publicInverse ?
	    g.claim(publicRelation, l0.SubrelationOf, l0.IsRelatedTo);
	    g.claim(publicRelation, l0.InstanceOf, relation);
	    g.claim(publicRelation, sr.IsBoundBy, element.getResource());
	    g.claim(type, l0.DomainOf, publicRelation);
	    g.claimLiteral(publicRelation, l0.HasName, g.getRelatedValue(element.getResource(), l0.HasName) +"_" + g.getRelatedValue(relation, l0.HasName)); 
	    Resource inverse = g.getPossibleInverse(relation);
	    if (inverse != null) {
	    	Resource publicInverse = g.newResource();
	    	g.claim(publicInverse, l0.SubrelationOf, inverse);
	    	g.claim(publicRelation, l0.InverseOf, publicInverse);
	    }
	    return publicRelation;
	    
	}
}
