/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.schema;



import gnu.trove.map.hash.THashMap;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;


/**
 * 
 */
public class DefaultSchema implements IMappingSchema<Resource,Object> {

    THashMap<Resource, ILinkType<Resource,Object>> domainLinkTypes = 
        new THashMap<Resource, ILinkType<Resource,Object>>();
    THashMap<Class<?>, ILinkType<Resource,Object>> rangeLinkTypes = 
        new THashMap<Class<?>, ILinkType<Resource,Object>>();
    
    public void addLinkType(SimpleLinkType<Object> linkType) {
        domainLinkTypes.put(linkType.domainType, linkType);
        rangeLinkTypes.put(linkType.rangeType, linkType);
    }
    
    public void addLinkType(AdaptedLinkType<Object> linkType) {
        domainLinkTypes.put(linkType.domainType, linkType);
        rangeLinkTypes.put(linkType.rangeType, linkType);
    }
    
    @Override
    public ILinkType<Resource,Object> linkTypeOfDomainElement(ReadGraph g, Resource element) throws MappingException {        
        try {
        	
        	for(Resource type : g.getTypes(element)) {

        		ILinkType<Resource,Object> linkType = domainLinkTypes.get(type);
        		if(linkType != null) return linkType;
        		
        	}
        	
        	throw new MappingException("Didn't find a link type for " +
        			NameUtils.getSafeName(g, element) + ".");
   				
        } catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public ILinkType<Resource,Object> linkTypeOfRangeElement(Object element) throws MappingException {
    	ILinkType<Resource,Object> type = rangeLinkTypes.get(element.getClass());
		if(type == null)  {
			for (Class<?> clazz : element.getClass().getInterfaces()) {
				type = rangeLinkTypes.get(clazz);
				if (type != null)
					return type;
				
			}
			throw new MappingException("Didn't find a link type for " +	element + ".");
		}
		return type;
    }

    
    public ILinkType<Resource,Object> linkTypeOfDomainType(ReadGraph g, Resource type)  {        
    	return domainLinkTypes.get(type);
    }
    
    public ILinkType<Resource,Object> linkTypeOfRangeType(Class<?> clazz) {
    	ILinkType<Resource,Object> type = rangeLinkTypes.get(clazz);
    	if(type == null)  {
    		// FIXME: c is not referenced at all, should it be?
    		// TODO: should this method take inheritance into account ?
			for (Class<?> c : clazz.getInterfaces()) {
				type = rangeLinkTypes.get(clazz);
				if (type != null)
					return type;
				
			}
		}
    	return null;
    }
}
