/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.Field;

import org.simantics.objmap.exceptions.MappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Accesses the given field of the element.
 * @author Hannu Niemist
 */
public class FieldAccessor<Range,T> implements IRangeAccessor<Range,T> {
    
    static final Logger LOGGER = LoggerFactory.getLogger(FieldAccessor.class);
    
	Field field;

	public FieldAccessor(Field field) {
		this.field = field;
	}

	@Override
	public T get(Range element) throws MappingException {
		try {
		    @SuppressWarnings("unchecked")
			T result = (T)field.get(element);
		    
	        if(LOGGER.isTraceEnabled())
	            LOGGER.trace("        FieldAccessor.get " +
	                    field.getName() + " -> " + result
	            );
	        
			return result;
		} catch (IllegalArgumentException e) {
			throw new MappingException(e);
		} catch (IllegalAccessException e) {
			throw new MappingException(e);
		}
	}

	@Override
	public boolean set(Range element, T value) throws MappingException {
		try {
			Object currentValue = field.get(element);
			
            if(LOGGER.isTraceEnabled())
                LOGGER.trace("        FieldAccessor.set " +
                        field.getName() + " " + currentValue +  
                        " -> " + value
                );
			
			if(value == null 
			        ? (currentValue == null || field.getType().isPrimitive()) 
			        : value.equals(currentValue))
				return false;			
			field.set(element, value);
			return true;
		} catch (IllegalArgumentException e) {
			throw new MappingException(e);
		} catch (IllegalAccessException e) {
			throw new MappingException(e);
		}
	}	
}
